/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.Extractors;
import org.eclipse.golo.runtime.Loader;
import org.eclipse.golo.runtime.MethodFinder;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.NamedArgumentsHelper;
import org.eclipse.golo.runtime.augmentation.DefiningModule;

class AugmentationMethodFinder
extends MethodFinder {
    private final Loader loader;

    AugmentationMethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        super(invocation, lookup);
        this.loader = new Loader(this.callerClass.getClassLoader());
    }

    private Stream<DefiningModule> getLocalCaller(Class<?> callingClass) {
        if (callingClass == null) {
            return Stream.empty();
        }
        return Stream.of(DefiningModule.ofLocal(callingClass));
    }

    private Stream<DefiningModule> getImportedModules(Class<?> sourceClass) {
        return Extractors.getImportedNames(sourceClass).filter(AugmentationMethodFinder::candidateImport).map(this.loader).filter(Objects::nonNull).map(DefiningModule::ofImport);
    }

    private static boolean candidateImport(String s) {
        return s != null && !s.startsWith("java") && !"gololang".equals(s);
    }

    private Stream<DefiningModule> getCallStack() {
        return Stream.of(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).filter(AugmentationMethodFinder::isCandidateInStackTrace).skip(1L).map(this.loader).filter(Objects::nonNull).map(DefiningModule::ofCallstack);
    }

    private static boolean isCandidateInStackTrace(String className) {
        return !className.startsWith("java.lang") && !className.startsWith("org.eclipse.golo");
    }

    private Stream<DefiningModule> getDefiningModules() {
        return Stream.of(this.getLocalCaller(this.callerClass), this.getImportedModules(this.callerClass), this.getCallStack(), this.getCallStack().flatMap(defining -> this.getImportedModules(defining.module()))).reduce(Stream.empty(), Stream::concat);
    }

    @Override
    protected int[] getArgumentsOrder(Method method, List<String> parameterNames, String[] argumentNames) {
        int[] argumentsOrder = new int[parameterNames.size()];
        argumentsOrder[0] = 0;
        for (int i = 0; i < argumentNames.length; ++i) {
            int actualPosition = parameterNames.indexOf(argumentNames[i]);
            NamedArgumentsHelper.checkArgumentPosition(actualPosition, argumentNames[i], method.getName() + parameterNames);
            argumentsOrder[actualPosition] = i + 1;
        }
        return argumentsOrder;
    }

    @Override
    public MethodHandle find() {
        return this.getDefiningModules().flatMap(dm -> dm.augmentationsFor(this.loader, this.invocation.receiverClass())).flatMap(aug -> aug.methodsMaching(this.invocation)).min(Comparator.naturalOrder()).flatMap(am -> this.toMethodHandle(am.method())).orElse(null);
    }
}

