/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.compiler.ir.FunctionContainer;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class Augmentation
extends GoloElement
implements FunctionContainer {
    private PackageAndClass target;
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();
    private final Set<String> names = new LinkedHashSet<String>();

    Augmentation(PackageAndClass target) {
        this.target = target;
    }

    @Override
    public Augmentation ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public PackageAndClass getTarget() {
        return this.target;
    }

    public boolean hasLocalTarget() {
        return this.target.packageName().isEmpty();
    }

    public void setTargetPackage(String packageName) {
        this.target = new PackageAndClass(packageName, this.target.className());
    }

    @Override
    public Set<GoloFunction> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    @Override
    public void addFunction(GoloFunction func) {
        this.functions.add(func);
        this.makeParentOf(func);
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public boolean hasNames() {
        return !this.names.isEmpty();
    }

    public Augmentation with(Object ... objects) {
        return this.with(Arrays.asList(objects));
    }

    public Augmentation with(Collection<?> objects) {
        if (objects != null) {
            for (Object o : objects) {
                if (o instanceof String) {
                    this.names.add((String)o);
                    continue;
                }
                if (o instanceof GoloFunction) {
                    this.addFunction((GoloFunction)o);
                    continue;
                }
                throw Augmentation.cantConvert("string or function", o);
            }
        }
        return this;
    }

    public void merge(Augmentation other) {
        if (!other.getTarget().equals(this.target)) {
            throw new IllegalArgumentException("Can't merge augmentations to different targets");
        }
        if (other != this) {
            this.names.addAll(other.getNames());
            this.addFunctions(other.getFunctions());
        }
    }

    public String toString() {
        return String.format("Augmentation<target=%s, names=%s, functions=%s>", this.getTarget(), this.getNames(), this.getFunctions());
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!this.functions.contains(original) || !(newElement instanceof GoloFunction)) {
            throw this.cantReplace(original, newElement);
        }
        this.functions.remove((GoloFunction)original);
        this.functions.add((GoloFunction)newElement);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitAugmentation(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (GoloFunction func : new LinkedList<GoloFunction>(this.functions)) {
            func.accept(visitor);
        }
    }
}

