/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbRefNode
extends DeploymentDescriptorNode<EjbReference> {
    EjbReference descriptor = null;

    @Override
    public EjbReference getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("ejb-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof EjbReferenceContainer) {
                try {
                    this.descriptor = ((EjbReferenceContainer)parentDesc).getEjbReference(value);
                    DOLUtils.getDefaultLogger().finer("Applying ref runtime to " + this.descriptor);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{"ejb-ref", value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, EjbReference ejbRef) {
        Element ejbRefNode = EjbRefNode.appendChild(parent, nodeName);
        EjbRefNode.appendTextChild((Node)ejbRefNode, "ejb-ref-name", ejbRef.getName());
        String jndiName = ejbRef.getJndiName();
        EjbDescriptor ejbReferee = ejbRef.getEjbDescriptor();
        if (ejbReferee != null && !ejbRef.isLocal() && ejbRef.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbReferee;
            String intf = ejbRef.isEJB30ClientView() ? ejbRef.getEjbInterface() : ejbRef.getEjbHomeInterface();
            jndiName = sessionDesc.getPortableJndiName(intf);
        }
        EjbRefNode.appendTextChild((Node)ejbRefNode, "jndi-name", jndiName);
        return ejbRefNode;
    }

    public static void writeEjbReferences(Node parent, EjbReferenceContainer descriptor) {
        Iterator ejbRefs = descriptor.getEjbReferenceDescriptors().iterator();
        if (ejbRefs.hasNext()) {
            EjbRefNode refNode = new EjbRefNode();
            while (ejbRefs.hasNext()) {
                EjbReference ejbRef = (EjbReference)ejbRefs.next();
                if (ejbRef.isLocal()) continue;
                refNode.writeDescriptor(parent, "ejb-ref", ejbRef);
            }
        }
    }
}

