/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.AttributeBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.JspTLDGenerator;
import com.sun.faces.generate.PropertyManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JspToFaceletsTLD21Generator
extends JspTLDGenerator {
    private static final String JSP_VERSION = "2.1";
    private static final String JSF_TLIB_VERSION = "2.1";
    private static Map<String, String> TAG_LIB_SCHEMA_ATTRIBUTES = new HashMap<String, String>();
    private static Map<String, List<String>> COMPONENT_PROPERTY_EXCLUDES;

    public JspToFaceletsTLD21Generator(PropertyManager propManager) {
        super(propManager);
    }

    public static void main(String[] args) {
        PropertyManager manager = PropertyManager.newInstance(args[0]);
        try {
            JspToFaceletsTLD21Generator generator = new JspToFaceletsTLD21Generator(manager);
            generator.generate(GeneratorUtil.getConfigBean(args[1]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getRtexprvalue(String tagName, String attributeName) {
        if ("id".equals(attributeName)) {
            return "true";
        }
        return super.getRtexprvalue(tagName, attributeName);
    }

    @Override
    protected void writeTldDescription() throws IOException {
        this.writer.startElement("taglib", TAG_LIB_SCHEMA_ATTRIBUTES);
        this.writer.writeComment("============== Tag Library Description Elements =============");
        this.writer.startElement("description");
        this.writer.writeText(this.propManager.getProperty("taglib.description"));
        this.writer.closeElement();
        this.writer.startElement("tlib-version");
        this.writer.writeText("2.1");
        this.writer.closeElement();
        this.writer.startElement("short-name");
        this.writer.writeText(this.propManager.getProperty("taglib.shortname"));
        this.writer.closeElement();
        try {
            String displayName = this.propManager.getProperty("taglib.displayname");
            this.writer.startElement("display-name");
            this.writer.writeText(displayName);
            this.writer.closeElement();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writer.startElement("uri");
        this.writer.writeText(this.propManager.getProperty("taglib.uri"));
        this.writer.closeElement();
    }

    @Override
    protected void writeTags() throws IOException {
        this.writer.writeComment("===================== HTML 4.0 basic tags ======================");
        Map<String, ComponentBean> componentsByComponentFamily = GeneratorUtil.getComponentFamilyComponentMap(this.configBean);
        Map<String, ArrayList<RendererBean>> renderersByComponentFamily = GeneratorUtil.getComponentFamilyRendererMap(this.configBean, this.propManager.getProperty("renderkit.id"));
        String targetPackage = this.propManager.getProperty("target.package");
        for (Map.Entry<String, ArrayList<RendererBean>> entry : renderersByComponentFamily.entrySet()) {
            String componentFamily = entry.getKey();
            List renderers = entry.getValue();
            for (RendererBean renderer : renderers) {
                String tagName;
                String descriptionText;
                if (renderer.isIgnoreAll()) continue;
                String rendererType = renderer.getRendererType();
                this.writer.startElement("tag");
                DescriptionBean description = renderer.getDescription("");
                if (description != null && (descriptionText = description.getDescription().trim()) != null) {
                    this.writer.startElement("description");
                    StringBuffer sb = new StringBuffer();
                    sb.append("<![CDATA[");
                    sb.append(descriptionText);
                    sb.append("]]>\n");
                    this.writer.writeText(sb.toString());
                    this.writer.closeElement();
                }
                if ((tagName = renderer.getTagName()) == null) {
                    tagName = this.makeTldTagName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType));
                }
                if (tagName == null) {
                    throw new IllegalStateException("Could not determine tag name");
                }
                this.writer.startElement("name");
                this.writer.writeText(tagName);
                this.writer.closeElement();
                if (GeneratorUtil.makeTagClassName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType)) == null) {
                    throw new IllegalStateException("Could not determine tag class name");
                }
                this.writer.startElement("tag-class");
                this.writer.writeText(targetPackage + '.' + GeneratorUtil.makeTagClassName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType)));
                this.writer.closeElement();
                this.writer.startElement("body-content");
                this.writer.writeText(this.getBodyContent(tagName));
                this.writer.closeElement();
                List<String> excludeComponentProperties = COMPONENT_PROPERTY_EXCLUDES.get(tagName);
                ComponentBean component = componentsByComponentFamily.get(componentFamily);
                for (PropertyBean property : component.getProperties()) {
                    String descriptionText2;
                    if (null == property || !property.isTagAttribute() || null != excludeComponentProperties && excludeComponentProperties.contains(property.getPropertyName())) continue;
                    this.writer.startElement("attribute");
                    description = property.getDescription("");
                    if (description != null && (descriptionText2 = description.getDescription().trim()) != null) {
                        this.writer.startElement("description");
                        StringBuffer sb = new StringBuffer();
                        sb.append("<![CDATA[");
                        sb.append(descriptionText2);
                        sb.append("]]>\n");
                        this.writer.writeText(sb.toString());
                        this.writer.closeElement();
                    }
                    String propertyName = property.getPropertyName();
                    this.writer.startElement("name");
                    this.writer.writeText(propertyName);
                    this.writer.closeElement();
                    this.writer.startElement("required");
                    this.writer.writeText(property.isRequired() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    this.writer.closeElement();
                    if (!"id".equals(propertyName)) {
                        if (property.isMethodExpressionEnabled()) {
                            this.writer.startElement("deferred-method");
                            this.writer.startElement("method-signature");
                            this.writer.writeText(property.getMethodSignature());
                            this.writer.closeElement(2);
                        } else if (property.isValueExpressionEnabled()) {
                            String type = property.getPropertyClass();
                            this.writer.startElement("deferred-value");
                            this.writer.startElement("type");
                            this.writer.writeText(type);
                            this.writer.closeElement(2);
                        } else {
                            this.writer.startElement("rtexprvalue");
                            this.writer.writeText(this.getRtexprvalue(tagName, propertyName));
                            this.writer.closeElement();
                        }
                    } else {
                        this.writer.startElement("rtexprvalue");
                        this.writer.writeText(this.getRtexprvalue(tagName, propertyName));
                        this.writer.closeElement();
                    }
                    this.writer.closeElement();
                }
                for (AttributeBean attribute : renderer.getAttributes()) {
                    String descriptionText3;
                    if (null == attribute || !attribute.isTagAttribute() || this.attributeShouldBeExcluded(renderer, attribute.getAttributeName())) continue;
                    this.writer.startElement("attribute");
                    description = attribute.getDescription("");
                    if (description != null && (descriptionText3 = description.getDescription().trim()) != null) {
                        this.writer.startElement("description");
                        StringBuffer sb = new StringBuffer();
                        sb.append("<![CDATA[");
                        sb.append(descriptionText3);
                        sb.append("]]>\n");
                        this.writer.writeText(sb.toString());
                        this.writer.closeElement();
                    }
                    String attributeName = attribute.getAttributeName();
                    this.writer.startElement("name");
                    this.writer.writeText(attributeName);
                    this.writer.closeElement();
                    this.writer.startElement("required");
                    this.writer.writeText(attribute.isRequired() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    this.writer.closeElement();
                    if (!"id".equals(attributeName)) {
                        String type = attribute.getAttributeClass();
                        this.writer.startElement("deferred-value");
                        this.writer.startElement("type");
                        this.writer.writeText(type);
                        this.writer.closeElement(2);
                    } else {
                        this.writer.startElement("rtexprvalue");
                        this.writer.writeText(this.getRtexprvalue(tagName, attributeName));
                        this.writer.closeElement();
                    }
                    this.writer.closeElement();
                }
                this.writer.startElement("attribute");
                this.writer.startElement("description");
                this.writer.writeText("The ValueExpression linking this component to a property in a backing bean");
                this.writer.closeElement();
                this.writer.startElement("name");
                this.writer.writeText("binding");
                this.writer.closeElement();
                this.writer.startElement("required");
                this.writer.writeText("false");
                this.writer.closeElement();
                this.writer.startElement("deferred-value");
                this.writer.startElement("type");
                this.writer.writeText("javax.faces.component.UIComponent");
                this.writer.closeElement(2);
                this.writer.closeElement(2);
            }
        }
        String tagDef = this.loadOptionalTags();
        if (tagDef != null) {
            this.writer.write(tagDef);
        }
    }

    static {
        TAG_LIB_SCHEMA_ATTRIBUTES.put("xmlns", "http://java.sun.com/xml/ns/javaee");
        TAG_LIB_SCHEMA_ATTRIBUTES.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        TAG_LIB_SCHEMA_ATTRIBUTES.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd");
        TAG_LIB_SCHEMA_ATTRIBUTES.put("version", "2.1");
        COMPONENT_PROPERTY_EXCLUDES = new HashMap<String, List<String>>();
        COMPONENT_PROPERTY_EXCLUDES.put("body", Arrays.asList("converter", "id", "rendered", "value"));
        COMPONENT_PROPERTY_EXCLUDES.put("button", Arrays.asList("converter", "fragment"));
        COMPONENT_PROPERTY_EXCLUDES.put("head", Arrays.asList("converter", "id", "rendered", "value"));
        COMPONENT_PROPERTY_EXCLUDES.put("link", Arrays.asList("converter", "fragment"));
    }
}

