/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.utils.LogFormatter;
import com.sun.jts.utils.RecoveryHooks.FailureInducer;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.INTERNAL;

class TransactionState {
    static final int STATE_NONE = 0;
    static final int STATE_ACTIVE = 1;
    static final int STATE_PREPARING = 2;
    static final int STATE_PREPARED_SUCCESS = 3;
    static final int STATE_PREPARED_FAIL = 4;
    static final int STATE_PREPARED_READONLY = 5;
    static final int STATE_COMMITTING = 6;
    static final int STATE_COMMITTED = 7;
    static final int STATE_ROLLING_BACK = 8;
    static final int STATE_ROLLED_BACK = 9;
    static final int STATE_COMMITTING_ONE_PHASE = 10;
    static final int STATE_COMMITTED_ONE_PHASE_OK = 11;
    static final int STATE_COMMIT_ONE_PHASE_ROLLED_BACK = 12;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_HAZARD = 13;
    static final int STATE_COMMIT_ONE_PHASE_HEURISTIC_MIXED = 14;
    static Logger _logger = LogDomains.getLogger(TransactionState.class, (String)"javax.enterprise.system.core.transaction");
    static RWLock freezeLock = new RWLock();
    GlobalTID globalTID = null;
    Long localTID = null;
    int state = 0;
    boolean subordinate = false;
    CoordinatorLog logRecord = null;
    Object logSection = null;
    static long sequenceNumber = 1L;
    static boolean inDoubt = false;
    static byte[] TIDTemplate = null;
    static final boolean[][] validStateChange = new boolean[][]{{false, true, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, true, false, false, false, false, false, true, false, true, false, false, false, false}, {false, false, false, true, true, true, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, true, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false}, {true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, true, true, true, true}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, false, false, false, false, false, false, false}};
    static final int XID_FORMAT_ID = 4871251;
    private static final String LOG_SECTION_NAME = "TS";

    TransactionState() {
    }

    TransactionState(CoordinatorLog log) {
        this.localTID = TransactionState.getSequenceNumber();
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID));
        this.state = 0;
        this.subordinate = false;
        if (log != null) {
            this.logRecord = log;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(GlobalTID globalTID, CoordinatorLog log) {
        this.globalTID = globalTID;
        this.localTID = TransactionState.getSequenceNumber();
        this.state = 0;
        this.subordinate = true;
        if (log != null) {
            this.logRecord = log;
            this.logRecord.setLocalTID(this.localTID);
            this.logSection = this.logRecord.createSection(LOG_SECTION_NAME);
        }
    }

    TransactionState(Long parentLocalTID, GlobalTID parentGlobalTID) {
        this.localTID = TransactionState.getSequenceNumber();
        this.globalTID = new GlobalTID(4871251, 0, TransactionState.generateTID(this.localTID));
        this.state = 0;
        this.subordinate = false;
    }

    int reconstruct(CoordinatorLog log) {
        int result = 0;
        this.logSection = log.createSection(LOG_SECTION_NAME);
        byte[][] logData = log.getData(this.logSection);
        int logState = 0;
        for (int i = 0; i < logData.length; ++i) {
            if (logData[i].length > 1) {
                logState |= ((logData[i][0] & 0xFF) << 8) + (logData[i][1] & 0xFF);
                continue;
            }
            _logger.log(Level.SEVERE, "jts.invalid_log_record_data", LOG_SECTION_NAME);
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.invalid_log_record_data", new Object[]{LOG_SECTION_NAME});
            throw new INTERNAL(msg);
        }
        if ((logState & 0x200) != 0) {
            result = 9;
        } else if ((logState & 0x80) != 0) {
            result = 7;
        } else if ((logState & 0x40) != 0) {
            result = 6;
        } else if ((logState & 0x100) != 0) {
            result = 8;
        } else if ((logState & 0x20) != 0) {
            result = 5;
        } else if ((logState & 0x10) != 0) {
            result = 4;
        } else if ((logState & 8) != 0) {
            result = 3;
        } else if ((logState & 0x400) != 0) {
            result = 10;
        } else if ((logState & 0x800) != 0) {
            result = 11;
        } else if ((logState & 0x1000) != 0) {
            result = 12;
        } else if ((logState & 0x2000) != 0) {
            result = 13;
        } else if ((logState & 0x4000) != 0) {
            result = 14;
        }
        this.state = result;
        this.subordinate = false;
        this.logRecord = log;
        return result;
    }

    boolean setState(int newState) {
        boolean result = false;
        if (validStateChange[this.state][newState]) {
            Integer failurePoint;
            String statestr;
            if (AdminUtil.bSampling) {
                switch (newState) {
                    case 3: {
                        AdminUtil.incrementPendingTransactionCount();
                        break;
                    }
                    case 5: {
                        AdminUtil.incrementPendingTransactionCount();
                        break;
                    }
                    case 7: {
                        AdminUtil.incrementCommitedTransactionCount();
                        break;
                    }
                    case 9: {
                        AdminUtil.incrementAbortedTransactionCount();
                        break;
                    }
                    case 8: {
                        AdminUtil.incrementUnpreparedAbortedTransactionCount();
                        break;
                    }
                }
            }
            switch (this.state) {
                case 2: 
                case 6: 
                case 10: {
                    if (_logger.isLoggable(Level.FINEST)) {
                        statestr = null;
                        switch (newState) {
                            case 2: {
                                statestr = "PREPARING";
                                break;
                            }
                            case 6: {
                                statestr = "COMMITTING";
                                break;
                            }
                            case 10: {
                                statestr = "COMMITTING_ONE_PHASE";
                                break;
                            }
                            default: {
                                statestr = "Illegal state ";
                            }
                        }
                        _logger.logp(Level.FINEST, "TransactionState", "setState()", "Releasing read lock on freeze : state " + statestr);
                    }
                    freezeLock.releaseReadLock();
                    if (!_logger.isLoggable(Level.FINEST)) break;
                    statestr = null;
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Released read lock on freeze");
                    switch (newState) {
                        case 2: {
                            statestr = "PREPARING";
                            break;
                        }
                        case 6: {
                            statestr = "COMMITTING";
                            break;
                        }
                        case 10: {
                            statestr = "COMMITTING_ONE_PHASE";
                            break;
                        }
                        default: {
                            statestr = "Illegal state ";
                        }
                    }
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Released read lock on freeze : state " + statestr);
                }
            }
            switch (newState) {
                case 2: 
                case 6: 
                case 10: {
                    if (_logger.isLoggable(Level.FINEST)) {
                        statestr = null;
                        switch (newState) {
                            case 2: {
                                statestr = "PREPARING";
                                break;
                            }
                            case 6: {
                                statestr = "COMMITTING";
                                break;
                            }
                            case 10: {
                                statestr = "COMMITTING_ONE_PHASE";
                                break;
                            }
                            default: {
                                statestr = "Illegal state ";
                            }
                        }
                        _logger.logp(Level.FINEST, "TransactionState", "setState()", "Acquiring read lock on freeze : state " + statestr);
                    }
                    freezeLock.acquireReadLock();
                    if (!_logger.isLoggable(Level.FINEST)) break;
                    statestr = null;
                    switch (newState) {
                        case 2: {
                            statestr = "PREPARING";
                            break;
                        }
                        case 6: {
                            statestr = "COMMITTING";
                            break;
                        }
                        case 10: {
                            statestr = "COMMITTING_ONE_PHASE";
                            break;
                        }
                        default: {
                            statestr = "Illegal state ";
                        }
                    }
                    _logger.logp(Level.FINEST, "TransactionState", "setState()", "Acquired read lock on freeze : state " + statestr);
                }
            }
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                failurePoint = null;
                switch (newState) {
                    case 2: {
                        failurePoint = 0;
                        break;
                    }
                    case 3: {
                        failurePoint = 1;
                        break;
                    }
                    case 4: {
                        failurePoint = 1;
                        break;
                    }
                    case 5: {
                        failurePoint = 1;
                        break;
                    }
                    case 10: {
                        failurePoint = 0;
                        break;
                    }
                    case 11: {
                        failurePoint = 3;
                        break;
                    }
                    case 12: {
                        failurePoint = 3;
                        break;
                    }
                    case 6: {
                        failurePoint = 2;
                        break;
                    }
                    case 7: {
                        failurePoint = 3;
                        break;
                    }
                    case 8: {
                        if (this.state == 3) {
                            failurePoint = 2;
                            break;
                        }
                        if (this.state == 4) {
                            failurePoint = 2;
                            break;
                        }
                        if (this.state == 5) {
                            failurePoint = 2;
                            break;
                        }
                        if (this.state != 1) break;
                        failurePoint = 0;
                        break;
                    }
                    case 9: {
                        failurePoint = 3;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, failurePoint);
            }
            this.state = newState;
            result = true;
            if (this.logRecord != null && (newState == 3 || newState == 4 || newState == 6 && this.subordinate || newState == 8 && this.subordinate || newState == 7 || newState == 9 || newState == 13 || newState == 14)) {
                byte[] byteData = new byte[]{(byte)((1 << this.state & 0xFF00) >> 8), (byte)(1 << this.state & 0xFF)};
                result = this.logRecord.addData(this.logSection, byteData);
            }
            if (this.logRecord != null && (newState == 3 || newState == 13 || newState == 14 || newState == 6 && this.subordinate || newState == 8 && this.subordinate)) {
                TransactionState.setInDoubt(true);
                result = this.logRecord.write(true);
            } else if (newState == 3 || newState == 13 || newState == 14 || newState == 6 && this.subordinate || newState == 8 && this.subordinate) {
                TransactionState.setInDoubt(true);
            }
            if (this.logRecord != null && (newState == 7 || newState == 9)) {
                result = this.logRecord.write(false);
            }
            if (FailureInducer.isFailureInducerActive() && !Thread.currentThread().getName().equals("JTS Resync Thread")) {
                failurePoint = null;
                switch (newState) {
                    case 11: {
                        failurePoint = 4;
                        break;
                    }
                    case 7: {
                        failurePoint = 4;
                        break;
                    }
                    case 9: {
                        failurePoint = 4;
                    }
                }
                FailureInducer.waitForFailure(this.globalTID, failurePoint);
            }
        }
        return result;
    }

    private static synchronized long getSequenceNumber() {
        return ++sequenceNumber;
    }

    static boolean inDoubt() {
        return inDoubt;
    }

    static void setInDoubt(boolean value) {
        inDoubt = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final byte[] generateTID(long localTID) {
        if (TIDTemplate == null) {
            Class<TransactionState> clazz = TransactionState.class;
            // MONITORENTER : com.sun.jts.CosTransactions.TransactionState.class
            if (TIDTemplate == null) {
                String serverName = Configuration.getServerName();
                int nameLength = serverName == null ? 0 : serverName.length();
                TIDTemplate = new byte[nameLength + 8];
                long epochNumber = new Date().getTime();
                TransactionState.TIDTemplate[4] = (byte)epochNumber;
                TransactionState.TIDTemplate[5] = (byte)(epochNumber >> 8);
                TransactionState.TIDTemplate[6] = (byte)(epochNumber >> 16);
                TransactionState.TIDTemplate[7] = (byte)(epochNumber >> 24);
                for (int i = 0; i < nameLength; ++i) {
                    TransactionState.TIDTemplate[i + 8] = (byte)serverName.charAt(i);
                }
            }
            // MONITOREXIT : clazz
        }
        byte[] result = new byte[TIDTemplate.length];
        System.arraycopy(TIDTemplate, 4, result, 4, TIDTemplate.length - 4);
        result[0] = (byte)localTID;
        result[1] = (byte)(localTID >> 8);
        result[2] = (byte)(localTID >> 16);
        result[3] = (byte)(localTID >> 24);
        return result;
    }
}

