/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;

@Service
public class ServerEnvironmentImpl
implements ServerEnvironment,
PostConstruct {
    @Inject
    StartupContext startupContext;
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kAppAltDDDirName = "altdd";
    public static final String kEJBStubDirName = "ejb";
    public static final String kGeneratedXMLDirName = "xml";
    public static final String kPolicyFileDirName = "policy";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kConfigXMLFileNameBackup = "domain.xml.bak";
    public static final String kLoggingPropertiesFileName = "logging.properties";
    public static final String kDefaultLoggingPropertiesFileName = "default-logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String DEFAULT_ADMIN_CONSOLE_CONTEXT_ROOT = "/admin";
    public static final String DEFAULT_ADMIN_CONSOLE_APP_NAME = "__admingui";
    private File root;
    private boolean verbose;
    private boolean debug;
    private ASenvPropertyReader asenv;
    private String domainName;
    private String instanceName;
    private RuntimeType serverType = RuntimeType.DAS;
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private ServerEnvironment.Status status = ServerEnvironment.Status.starting;

    public ServerEnvironmentImpl() {
    }

    public ServerEnvironmentImpl(File root) {
        this.root = root.getAbsoluteFile();
        this.asenv = new ASenvPropertyReader();
    }

    /*
     * WARNING - void declaration
     */
    public void postConstruct() {
        void var3_10;
        String installRoot = this.startupContext.getArguments().getProperty(INSTALL_ROOT_PROP_NAME);
        if (installRoot == null) {
            installRoot = System.getProperty(INSTALL_ROOT_PROP_NAME) != null ? System.getProperty(INSTALL_ROOT_PROP_NAME) : System.getProperty("user.dir");
        }
        this.asenv = new ASenvPropertyReader(new File(installRoot));
        if (this.root == null) {
            String envVar = System.getProperty(INSTANCE_ROOT_PROP_NAME);
            if (envVar != null) {
                this.root = new File(envVar);
            } else {
                void var3_5;
                String string = this.startupContext.getArguments().getProperty(INSTANCE_ROOT_PROP_NAME);
                if (string == null) {
                    String string2 = installRoot;
                }
                this.root = new File((String)var3_5);
            }
        }
        this.asenv.getProps().put(INSTANCE_ROOT_PROP_NAME, this.root.getAbsolutePath());
        for (Map.Entry entry : this.asenv.getProps().entrySet()) {
            if (entry.getValue() == null) continue;
            File location = new File((String)entry.getValue());
            if (!location.isAbsolute()) {
                location = new File(this.asenv.getProps().get(INSTANCE_ROOT_PROP_NAME), (String)entry.getValue());
            }
            System.setProperty((String)entry.getKey(), location.getAbsolutePath());
        }
        Properties args = this.startupContext.getArguments();
        this.verbose = Boolean.parseBoolean(args.getProperty("-verbose"));
        this.debug = Boolean.parseBoolean(args.getProperty("-debug"));
        String string = args.getProperty("-domainname");
        if (!this.ok(string)) {
            String string3 = this.root.getName();
        }
        this.domainName = var3_10;
        String string4 = args.getProperty("-instancename");
        this.instanceName = !this.ok(string4) ? "server" : string4;
        this.asenv.getProps().put("com.sun.aas.instanceName", this.instanceName);
        System.setProperty("com.sun.aas.instanceName", this.instanceName);
        String typeString = args.getProperty("-type");
        this.serverType = RuntimeType.getDefault();
        try {
            if (typeString != null) {
                this.serverType = RuntimeType.valueOf((String)typeString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public File getInstanceRoot() {
        return this.root;
    }

    @Deprecated
    public File getDomainRoot() {
        return this.getInstanceRoot();
    }

    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    public File getConfigDirPath() {
        return new File(this.root, kConfigDirName);
    }

    public File getApplicationRepositoryPath() {
        return new File(this.root, kRepositoryDirName);
    }

    public File getApplicationStubPath() {
        return new File(this.root, kGeneratedDirName);
    }

    public File getInitFilePath() {
        return new File(this.getConfigDirPath(), kInitFileName);
    }

    public File getLibPath() {
        return new File(this.root, "lib");
    }

    public File getApplicationEJBStubPath() {
        return new File(this.getApplicationStubPath(), kEJBStubDirName);
    }

    public File getApplicationGeneratedXMLPath() {
        return new File(this.getApplicationStubPath(), kGeneratedXMLDirName);
    }

    public File getApplicationCompileJspPath() {
        return new File(this.getApplicationStubPath(), "jsp");
    }

    public File getApplicationPolicyFilePath() {
        return new File(this.getApplicationStubPath(), kPolicyFileDirName);
    }

    public File getApplicationAltDDPath() {
        return new File(this.getApplicationStubPath(), kAppAltDDDirName);
    }

    public final String getProp(String key) {
        return this.getProps().get(key);
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.asenv.getProps());
    }

    public File getDefaultAdminConsoleFolderOnDisk() {
        File install = new File(this.asenv.getProps().get(INSTALL_ROOT_PROP_NAME));
        File agp = new File(new File(new File(install, "lib"), "install"), kRepositoryDirName);
        return agp;
    }

    public File getMasterPasswordFile() {
        return new File(this.getInstanceRoot(), "master-password");
    }

    public File getJKS() {
        return new File(this.getConfigDirPath(), "keystore.jks");
    }

    public File getTrustStore() {
        return new File(this.getConfigDirPath(), "cacerts.jks");
    }

    public ServerEnvironment.Status getStatus() {
        return this.status;
    }

    public void setStatus(ServerEnvironment.Status status) {
        this.status = status;
    }

    public boolean isEmbedded() {
        return this.serverType == RuntimeType.EMBEDDED;
    }

    public RuntimeType getRuntimeType() {
        return this.serverType;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isInstance() {
        return this.serverType == RuntimeType.INSTANCE;
    }

    public boolean isDas() {
        return this.serverType == RuntimeType.DAS;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

