/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.IOException;
import java.net.URLConnection;
import org.apache.naming.resources.ResourceAttributes;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntry;

final class BundleEntryAttributes
extends ResourceAttributes {
    private static final int CREATION_DATE_UNKNOWN = 0;
    private static final long TIME_NOT_SET = -1L;
    private static final long CONTENT_LENGTH_NOT_SET = -1L;
    private static final long serialVersionUID = 7799793247259935763L;
    private final transient BundleEntry bundleEntry;
    private final String[] attrIds;

    BundleEntryAttributes(BundleEntry bundleEntry, String[] attrIds) {
        this.bundleEntry = bundleEntry;
        this.attrIds = attrIds;
        this.setCollection(this.bundleEntry.isDirectory());
        this.getName();
        try {
            URLConnection urlConnection = this.getBundleEntryURLConnection();
            this.getLastModified(urlConnection);
            this.getCreation(urlConnection);
            this.getContentLength(urlConnection);
        }
        catch (IOException iOException) {}
    }

    public long getCreation() {
        try {
            return this.getCreation(this.getBundleEntryURLConnection());
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long getCreation(URLConnection urlConnection) {
        long creation = -1L;
        if ((this.attrPresent("creationdate") || this.attrPresent("creation-date")) && (creation = super.getCreation()) == -1L) {
            creation = this.determineDate(urlConnection);
            if (creation == 0L) {
                creation = this.determineLastModified(urlConnection);
            }
            this.setCreation(creation);
        }
        return creation;
    }

    private long determineDate(URLConnection urlConnection) {
        return urlConnection.getDate();
    }

    private boolean attrPresent(String attrId) {
        if (this.attrIds == null) {
            return true;
        }
        String[] stringArray = this.attrIds;
        int n = this.attrIds.length;
        int n2 = 0;
        while (n2 < n) {
            String ai = stringArray[n2];
            if (ai.equals(attrId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public long getLastModified() {
        try {
            return this.getLastModified(this.getBundleEntryURLConnection());
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long getLastModified(URLConnection urlConnection) {
        long lastModified = -1L;
        if ((this.attrPresent("getlastmodified") || this.attrPresent("last-modified")) && (lastModified = super.getLastModified()) == -1L && (lastModified = this.determineLastModified(urlConnection)) != -1L) {
            this.setLastModified(lastModified);
        }
        return lastModified;
    }

    private long determineLastModified(URLConnection urlConnection) {
        return urlConnection.getLastModified();
    }

    public String getName() {
        if (!this.attrPresent("displayname")) {
            return null;
        }
        String name = super.getName();
        if (name == null) {
            name = this.bundleEntry.getName();
        }
        return name;
    }

    public long getContentLength() {
        try {
            return this.getContentLength(this.getBundleEntryURLConnection());
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private long getContentLength(URLConnection urlConnection) {
        long contentLength = -1L;
        if ((this.attrPresent("getcontentlength") || this.attrPresent("content-length")) && (contentLength = super.getContentLength()) == -1L && (contentLength = this.determineContentLength()) != -1L) {
            this.setContentLength(contentLength);
        }
        return contentLength;
    }

    private long determineContentLength() {
        return this.bundleEntry.getContentLength();
    }

    private URLConnection getBundleEntryURLConnection() throws IOException {
        return this.bundleEntry.getURL().openConnection();
    }
}

