/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpQuadPattern
extends Op0 {
    private Node graphNode;
    private BasicPattern triples;
    private QuadPattern quads = null;

    public static boolean isQuadPattern(Op op) {
        return op instanceof OpQuadPattern;
    }

    public OpQuadPattern(Node quadNode, BasicPattern triples) {
        this.graphNode = quadNode;
        this.triples = triples;
    }

    private void initQuads() {
        if (this.quads == null) {
            this.quads = new QuadPattern();
            for (Triple t : this.triples) {
                this.quads.add(new Quad(this.graphNode, t));
            }
        }
    }

    public QuadPattern getPattern() {
        this.initQuads();
        return this.quads;
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public BasicPattern getBasicPattern() {
        return this.triples;
    }

    public boolean isEmpty() {
        return this.triples.size() == 0;
    }

    public boolean isDefaultGraph() {
        return Quad.isDefaultGraph(this.graphNode);
    }

    public boolean isUnionGraph() {
        return Quad.isUnionGraph(this.graphNode);
    }

    @Override
    public String getName() {
        return "quadpattern";
    }

    @Override
    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op0 copy() {
        return new OpQuadPattern(this.graphNode, this.triples);
    }

    @Override
    public int hashCode() {
        return this.graphNode.hashCode() ^ this.triples.hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpQuadPattern)) {
            return false;
        }
        OpQuadPattern opQuad = (OpQuadPattern)other;
        if (!this.graphNode.equals(opQuad.graphNode)) {
            return false;
        }
        return this.triples.equiv(opQuad.triples, labelMap);
    }
}

