/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDFS;

public class OntNamedDataRangeImpl
extends OntObjectImpl
implements OntDataRange.Named {
    public OntNamedDataRangeImpl(Node n, EnhGraph g) {
        super(OntNamedDataRangeImpl.checkNamed(n), g);
    }

    public Class<OntDataRange.Named> objectType() {
        return OntDataRange.Named.class;
    }

    @Override
    public boolean isBuiltIn() {
        return this.getModel().isBuiltIn(this);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntNamedDataRangeImpl.getOptionalRootStatement(this, RDFS.Datatype);
    }

    @Override
    public Stream<OntDataRange> equivalentClasses() {
        if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE)) {
            return Stream.empty();
        }
        return this.objects(OWL2.equivalentClass, OntDataRange.class);
    }

    @Override
    public OntStatement addEquivalentClassStatement(OntDataRange other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE, "owl:equivalentClass");
        return this.addStatement(OWL2.equivalentClass, other);
    }

    @Override
    public OntDataRange.Named removeEquivalentClass(Resource other) {
        OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE, "owl:equivalentClass");
        this.remove(OWL2.equivalentClass, other);
        return this;
    }

    @Override
    public RDFDatatype toRDFDatatype() {
        return this.getModel().getRDFDatatype(this.getURI());
    }
}

