/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;

@FunctionalInterface
public interface EnhNodeFinder {
    public static final EnhNodeFinder ANY_SUBJECT = eg -> Graphs.listSubjects(eg.asGraph());
    public static final EnhNodeFinder ANY_BLANK_SUBJECT = eg -> Iterators.distinct(eg.asGraph().find().mapWith(Triple::getSubject).filterKeep(Node::isBlank));
    public static final EnhNodeFinder ANY_SUBJECT_AND_OBJECT = eg -> Graphs.listSubjectsAndObjects(eg.asGraph());
    public static final EnhNodeFinder ANYTHING = eg -> Graphs.listAllNodes(eg.asGraph());
    public static final EnhNodeFinder NOTHING = eg -> NullIterator.instance();
    public static final EnhNodeFinder ANY_TYPED = new ByPredicate(RDF.type);

    public ExtendedIterator<Node> iterator(EnhGraph var1);

    default public Stream<Node> find(EnhGraph eg) {
        return Iterators.asStream(this.iterator(eg));
    }

    default public EnhNodeFinder restrict(EnhNodeFilter filter) {
        if (Objects.requireNonNull(filter, "Null restriction filter.").equals(EnhNodeFilter.TRUE)) {
            return this;
        }
        if (filter.equals(EnhNodeFilter.FALSE)) {
            return eg -> NullIterator.instance();
        }
        return eg -> this.iterator(eg).filterKeep(n -> filter.test((Node)n, eg));
    }

    public static class ByPredicate
    implements EnhNodeFinder {
        protected final Node predicate;

        public ByPredicate(Property predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Null predicate.").asNode();
        }

        @Override
        public ExtendedIterator<Node> iterator(EnhGraph eg) {
            return Iterators.distinct(eg.asGraph().find(Node.ANY, this.predicate, Node.ANY).mapWith(Triple::getSubject));
        }
    }

    public static class ByTypes
    implements EnhNodeFinder {
        protected final List<Node> types;

        public ByTypes(Collection<Resource> types) {
            if (types.isEmpty()) {
                throw new IllegalStateException();
            }
            this.types = types.stream().map(FrontsNode::asNode).distinct().toList();
        }

        @Override
        public ExtendedIterator<Node> iterator(EnhGraph eg) {
            if (this.types.size() == 1) {
                return eg.asGraph().find(Node.ANY, RDF.Nodes.type, this.types.get(0)).mapWith(Triple::getSubject);
            }
            return Iterators.distinct(Iterators.flatMap(WrappedIterator.create(this.types.iterator()), type -> eg.asGraph().find(Node.ANY, RDF.Nodes.type, (Node)type)).mapWith(Triple::getSubject));
        }
    }

    public static class ByType
    implements EnhNodeFinder {
        protected final Node type;

        public ByType(Resource type) {
            this(Objects.requireNonNull(type, "Null type.").asNode());
        }

        public ByType(Node type) {
            this.type = Objects.requireNonNull(type, "Null type.");
        }

        @Override
        public ExtendedIterator<Node> iterator(EnhGraph eg) {
            return eg.asGraph().find(Node.ANY, RDF.Nodes.type, this.type).mapWith(Triple::getSubject);
        }
    }
}

