/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Spliterator;
import java.util.function.Consumer;

public class SparseArraySubSpliterator<E>
implements Spliterator<E> {
    private final E[] entries;
    private final int fromIndex;
    private int pos;
    private final float fillRatio;
    private final Runnable checkForConcurrentModification;

    public SparseArraySubSpliterator(E[] entries, int fromIndex, int toIndex, float fillRatio, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.fromIndex = fromIndex;
        this.pos = toIndex;
        this.fillRatio = fillRatio;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArraySubSpliterator(E[] entries, int estimatedElementsCount, Runnable checkForConcurrentModification) {
        this(entries, 0, entries.length, (float)estimatedElementsCount / (float)entries.length, checkForConcurrentModification);
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        this.checkForConcurrentModification.run();
        while (this.fromIndex <= --this.pos) {
            if (null == this.entries[this.pos]) continue;
            action.accept(this.entries[this.pos]);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        --this.pos;
        while (this.fromIndex <= this.pos) {
            if (null != this.entries[this.pos]) {
                action.accept(this.entries[this.pos]);
            }
            --this.pos;
        }
        this.checkForConcurrentModification.run();
    }

    @Override
    public Spliterator<E> trySplit() {
        int entriesCount = this.pos - this.fromIndex;
        if (entriesCount < 2) {
            return null;
        }
        if (this.estimateSize() < 2L) {
            return null;
        }
        int toIndexOfSubIterator = this.pos;
        this.pos = this.fromIndex + (entriesCount >>> 1);
        return new SparseArraySubSpliterator<E>(this.entries, this.pos, toIndexOfSubIterator, this.fillRatio, this.checkForConcurrentModification);
    }

    @Override
    public long estimateSize() {
        return (long)(this.fillRatio * (float)(this.pos - this.fromIndex)) + 1L;
    }

    @Override
    public int characteristics() {
        return 1281;
    }
}

