/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.rrobot.model.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Policy implements Enumerator
{
    DYNAMIC(0, "DYNAMIC", "DYNAMIC"),
    STATIC(1, "STATIC", "STATIC");

    public static final int DYNAMIC_VALUE = 0;
    public static final int STATIC_VALUE = 1;
    private static final Policy[] VALUES_ARRAY;
    public static final List<Policy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Policy[]{DYNAMIC, STATIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Policy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Policy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Policy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Policy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Policy get(int value) {
        switch (value) {
            case 0: {
                return DYNAMIC;
            }
            case 1: {
                return STATIC;
            }
        }
        return null;
    }

    private Policy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

