/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PackagingFormat implements Enumerator
{
    NONE(0, "none", "none"),
    ALL(1, "all", "all"),
    IMAGE(2, "image", "image"),
    EXE(3, "exe", "exe"),
    MSI(4, "msi", "msi"),
    DMG(5, "dmg", "dmg"),
    RPM(6, "rpm", "rpm"),
    DEB(7, "deb", "deb");

    public static final int NONE_VALUE = 0;
    public static final int ALL_VALUE = 1;
    public static final int IMAGE_VALUE = 2;
    public static final int EXE_VALUE = 3;
    public static final int MSI_VALUE = 4;
    public static final int DMG_VALUE = 5;
    public static final int RPM_VALUE = 6;
    public static final int DEB_VALUE = 7;
    private static final PackagingFormat[] VALUES_ARRAY;
    public static final List<PackagingFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PackagingFormat[]{NONE, ALL, IMAGE, EXE, MSI, DMG, RPM, DEB};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PackagingFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackagingFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PackagingFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackagingFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PackagingFormat get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ALL;
            }
            case 2: {
                return IMAGE;
            }
            case 3: {
                return EXE;
            }
            case 4: {
                return MSI;
            }
            case 5: {
                return DMG;
            }
            case 6: {
                return RPM;
            }
            case 7: {
                return DEB;
            }
        }
        return null;
    }

    private PackagingFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

