/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.ui.internal;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.css_property;
import org.eclipse.fx.ide.css.cssDsl.selector;
import org.eclipse.fx.ide.css.cssext.ICSSExtModelProvider;
import org.eclipse.fx.ide.css.cssext.ICssExtManager;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;
import org.eclipse.fx.ide.css.cssext.parser.CssExtParser;
import org.eclipse.fx.ide.css.cssext.proposal.CssExtProposalContributor;
import org.eclipse.fx.ide.css.cssext.ui.doc.CssExtDocParser;
import org.eclipse.fx.ide.css.cssext.ui.internal.CssExtDslActivator;
import org.eclipse.fx.ide.css.extapi.CssExt;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.xtext.naming.IQualifiedNameProvider;

public class DefaultCssExtProvider
implements CssExt {
    @Inject
    private ICssExtManager cssExtManager;
    @Inject
    private CssExtParser parser;
    @Inject
    private CssExtDocParser docParser;
    @Inject
    private IQualifiedNameProvider nameProvider;

    public DefaultCssExtProvider() {
        Injector i = CssExtDslActivator.getInstance().getInjector("org.eclipse.fx.ide.css.cssext.CssExtDsl");
        i.injectMembers((Object)this);
    }

    public String getDocumentationHeader(IFile f, EObject context, EObject obj) {
        return this.docParser.getDocHead(f, obj);
    }

    public String getDocumentation(IFile f, EObject context, EObject obj) {
        return this.docParser.getDocumentation(f, obj);
    }

    public List<Proposal> getPropertyProposalsForSelector(IFile f, EObject context, List<selector> selectors) {
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        ArrayList defs = new ArrayList();
        if (selectors == null || selectors.isEmpty()) {
            defs.addAll(this.cssExtManager.findAllProperties(f, context));
        } else {
            for (selector selector2 : selectors) {
                defs.addAll(this.cssExtManager.findPropertiesBySelector(f, context, selector2));
            }
        }
        if (defs.isEmpty()) {
            defs.addAll(this.cssExtManager.findAllProperties(f, context));
        }
        for (PropertyDefinition def : defs) {
            result.add(this.createProposalForPropertyDefinition(def));
        }
        return result;
    }

    private Proposal createProposalForPropertyDefinition(final PropertyDefinition def) {
        Proposal p = new Proposal(){

            public String getProposal() {
                return def.getName();
            }

            public int getPriority() {
                return 0;
            }

            public String getLabel() {
                return def.getName();
            }

            public String getImageUrl() {
                return null;
            }

            public Object getAdditionalInfo() {
                return def;
            }

            public Proposal.Type getType() {
                return Proposal.Type.Property;
            }
        };
        return p;
    }

    public List<Proposal> getValueProposalsForProperty(IFile f, EObject context, List<selector> selector2, css_property property, List<CssTok> prefixTok, String prefixString) {
        return this.parser.findProposals(f, context, null, property.getName(), prefixTok, prefixString);
    }

    public void bindCssExtProposalContributor(CssExtProposalContributor c) {
        this.cssExtManager.addCssExtProposalContributer(c);
    }

    public void unbindCssExtProposalContributor(CssExtProposalContributor c) {
        this.cssExtManager.removeCssExtProposalContributer(c);
    }

    public void bindCssExtensionModelProvider(ICSSExtModelProvider p) {
        this.cssExtManager.addCssExtensionModelProvider(p);
    }

    public void unbindCssExtensionModelProvider(ICSSExtModelProvider p) {
        this.cssExtManager.removeCssExtensionModelProvider(p);
    }
}

