/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.fx.ide.ui.wizards.AbstractJDTElementPage;
import org.eclipse.fx.ide.ui.wizards.template.IGenerator;
import org.eclipse.fx.ide.ui.wizards.template.JDTElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractNewJDTElementWizard<O extends JDTElement>
extends Wizard
implements INewWizard {
    private IPackageFragmentRoot root;
    private IPackageFragment fragment;
    private IFile file;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IJavaElement jElement = this.getInitialJavaElement(selection);
        this.root = this.getFragmentRoot(jElement);
        this.fragment = this.getFragment(jElement);
    }

    public IPackageFragmentRoot getRoot() {
        if (this.getPages().length > 0 && this.getPages()[0] instanceof AbstractJDTElementPage) {
            return ((AbstractJDTElementPage)this.getPages()[0]).getFragmentRoot();
        }
        return this.root;
    }

    public IPackageFragment getFragment() {
        if (this.getPages().length > 0 && this.getPages()[0] instanceof AbstractJDTElementPage) {
            return ((AbstractJDTElementPage)this.getPages()[0]).getFragment();
        }
        return this.fragment;
    }

    public IPackageFragmentRoot getInitialRoot() {
        return this.root;
    }

    public IPackageFragment getInitialFragment() {
        return this.fragment;
    }

    private IPackageFragment getFragment(IJavaElement jElement) {
        if (jElement instanceof IPackageFragment) {
            return (IPackageFragment)jElement;
        }
        return null;
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IAdaptable adaptable;
        Object selectedElement;
        IJavaElement jelem = null;
        if (!(selection == null || selection.isEmpty() || !((selectedElement = selection.getFirstElement()) instanceof IAdaptable) || (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) != null && jelem.exists())) {
            jelem = null;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null && resource.getType() != 8) {
                while (jelem == null && resource.getType() != 4) {
                    resource = resource.getParent();
                    jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
                }
                if (jelem == null) {
                    jelem = JavaCore.create((IResource)resource);
                }
            }
        }
        return jelem;
    }

    protected IPackageFragmentRoot getFragmentRoot(IJavaElement elem) {
        IPackageFragmentRoot initRoot = null;
        if (elem != null) {
            initRoot = (IPackageFragmentRoot)elem.getAncestor(3);
            try {
                IJavaProject jproject;
                if ((initRoot == null || initRoot.getKind() != 1) && (jproject = elem.getJavaProject()) != null) {
                    initRoot = null;
                    if (jproject.exists()) {
                        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (roots[i].getKind() == 1) {
                                initRoot = roots[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = jproject.getPackageFragmentRoot(jproject.getResource());
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return initRoot;
    }

    protected abstract IGenerator<O> getGenerator();

    public O getDomainClass() {
        return ((AbstractJDTElementPage)this.getPages()[0]).getClazz();
    }

    protected Set<String> getRequiredBundles() {
        HashSet<String> rv = new HashSet<String>();
        rv.add("javax.inject");
        return rv;
    }

    public boolean performFinish() {
        O clazz = this.getDomainClass();
        if (clazz == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"No domain object", (String)"Please file a bug against e(fx)clipse with steps to reproduce this problem");
            return false;
        }
        String content = this.getGenerator().generateContent(clazz).toString();
        if (((JDTElement)clazz).getFragmentRoot() == null) {
            return false;
        }
        IFile file = this.createFile();
        if (file != null) {
            block8: {
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
                    break block8;
                }
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"File exists", (String)("The file " + file.getName() + " already exists. Would you like to proceed?"))) {
                    file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 3, null);
                    break block8;
                }
                return false;
            }
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    protected abstract IFile createFile();

    public IFile getFile() {
        return this.file;
    }
}

