/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.stage;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.eclipse.fx.ui.controls.stage.Frame;
import org.eclipse.fx.ui.controls.stage.FrameEvent;

public abstract class ResizeableFramePane
extends StackPane
implements Frame {
    private Rectangle2D backupWindowBounds;
    private double mouseDragDeltaX;
    private double mouseDragDeltaY;
    private Node resizeLeft;
    private Node resizeRight;
    private Node resizeBottom;
    private Node resizeTop;
    private Node resizeCornerRightBottom;
    private Node resizeCornerRightTop;
    private Node resizeCornerLeftBottom;
    private Node resizeCornerLeftTop;
    private BooleanProperty minimizable = new SimpleBooleanProperty((Object)this, "minimizable", true);
    private BooleanProperty maximizable = new SimpleBooleanProperty((Object)this, "maximizable", true);
    private BooleanProperty resizeable = new SimpleBooleanProperty((Object)this, "resizeable", true);
    private ReadOnlyBooleanWrapper lightweight = new ReadOnlyBooleanWrapper((Object)this, "lightweight", false);
    final int width = 10;

    public ResizeableFramePane() {
        this(false);
    }

    public ResizeableFramePane(boolean lighweight) {
        this.lightweight.set(lighweight);
        Node windowNode = this.createWindowArea();
        this.getChildren().add((Object)windowNode);
        this.initResize();
    }

    private void initResize() {
        this.initResizeLeft();
        this.initResizeRight();
        this.initResizeTop();
        this.initResizeBottom();
        this.initResizeCornerRightBottom();
        this.initResizeCornerRightTop();
        this.initResizeCornerLeftBottom();
        this.initResizeCornerLeftTop();
    }

    private void initResizeBottom() {
        this.resizeBottom = ResizeableFramePane.createBottomResize();
        this.resizeBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeBottom);
        ResizeHandler resizeHandler = new ResizeHandler(Location.BOTTOM);
        this.resizeBottom.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeBottom.setOnMouseDragged((EventHandler)resizeHandler);
    }

    private void initResizeTop() {
        this.resizeTop = ResizeableFramePane.createTopResize();
        this.resizeTop.setManaged(false);
        this.getChildren().add((Object)this.resizeTop);
        ResizeHandler h = new ResizeHandler(Location.TOP);
        this.resizeTop.setOnMousePressed((EventHandler)h);
        this.resizeTop.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeLeft() {
        this.resizeLeft = ResizeableFramePane.createLeftResize();
        this.resizeLeft.setManaged(false);
        this.getChildren().add((Object)this.resizeLeft);
        ResizeHandler h = new ResizeHandler(Location.LEFT);
        this.resizeLeft.setOnMousePressed((EventHandler)h);
        this.resizeLeft.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeRight() {
        this.resizeRight = ResizeableFramePane.createRightResize();
        this.resizeRight.setManaged(false);
        this.getChildren().add((Object)this.resizeRight);
        ResizeHandler h = new ResizeHandler(Location.RIGHT);
        this.resizeRight.setOnMousePressed((EventHandler)h);
        this.resizeRight.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeCornerRightBottom() {
        this.resizeCornerRightBottom = ResizeableFramePane.createResizeCornerRightBottom();
        this.resizeCornerRightBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerRightBottom);
        ResizeHandler h = new ResizeHandler(Location.BOTTOM, Location.RIGHT);
        this.resizeCornerRightBottom.setOnMousePressed((EventHandler)h);
        this.resizeCornerRightBottom.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeCornerRightTop() {
        this.resizeCornerRightTop = ResizeableFramePane.createResizeCornerRightTop();
        this.resizeCornerRightTop.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerRightTop);
        ResizeHandler h = new ResizeHandler(Location.TOP, Location.RIGHT);
        this.resizeCornerRightTop.setOnMousePressed((EventHandler)h);
        this.resizeCornerRightTop.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeCornerLeftBottom() {
        this.resizeCornerLeftBottom = ResizeableFramePane.createResizeCornerLeftBottom();
        this.resizeCornerLeftBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerLeftBottom);
        ResizeHandler h = new ResizeHandler(Location.BOTTOM, Location.LEFT);
        this.resizeCornerLeftBottom.setOnMousePressed((EventHandler)h);
        this.resizeCornerLeftBottom.setOnMouseDragged((EventHandler)h);
    }

    private void initResizeCornerLeftTop() {
        this.resizeCornerLeftTop = ResizeableFramePane.createResizeCornerLeftTop();
        this.resizeCornerLeftTop.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerLeftTop);
        ResizeHandler h = new ResizeHandler(Location.TOP, Location.LEFT);
        this.resizeCornerLeftTop.setOnMousePressed((EventHandler)h);
        this.resizeCornerLeftTop.setOnMouseDragged((EventHandler)h);
    }

    protected void registerTitleBar(Node node) {
        node.setOnMousePressed(event -> {
            this.mouseDragDeltaX = event.getSceneX();
            this.mouseDragDeltaY = event.getSceneY();
        });
        node.setOnMouseDragged(event -> {
            this.getStage().setX(event.getScreenX() - this.mouseDragDeltaX);
            this.getStage().setY(event.getScreenY() - this.mouseDragDeltaY);
        });
        node.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                this.maximize();
            }
        });
    }

    protected abstract Node createWindowArea();

    protected Stage getStage() {
        return (Stage)this.getScene().getWindow();
    }

    private static Node createResizeCornerRightBottom() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-right-bottom");
        return resizeCorner;
    }

    private static Node createResizeCornerRightTop() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-right-top");
        return resizeCorner;
    }

    private static Node createResizeCornerLeftBottom() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-left-bottom");
        return resizeCorner;
    }

    private static Node createResizeCornerLeftTop() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-left-top");
        return resizeCorner;
    }

    private static Node createLeftResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-left");
        return resizeCorner;
    }

    private static Node createRightResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-right");
        return resizeCorner;
    }

    private static Node createTopResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-top");
        return resizeCorner;
    }

    private static Node createBottomResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-bottom");
        return resizeCorner;
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.impl_contentProperty();
    }

    protected abstract ObjectProperty<Node> impl_contentProperty();

    @Override
    public final void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final StringProperty titleProperty() {
        return this.impl_titleProperty();
    }

    protected abstract StringProperty impl_titleProperty();

    @Override
    public final void setClientArea(Node node) {
        this.clientAreaProperty().set((Object)node);
    }

    public final Node getClientArea() {
        return (Node)this.clientAreaProperty().get();
    }

    public final ObjectProperty<Node> clientAreaProperty() {
        return this.impl_clientAreaProperty();
    }

    protected abstract ObjectProperty<Node> impl_clientAreaProperty();

    protected void maximize() {
        if (!this.isLightweight()) {
            Stage stage = this.getStage();
            double stageY = stage.getY();
            Screen screen = (Screen)Screen.getScreensForRectangle((double)stage.getX(), (double)stageY, (double)1.0, (double)1.0).get(0);
            Rectangle2D bounds = screen.getVisualBounds();
            if (bounds.getMinX() == stage.getX() && bounds.getMinY() == stageY && bounds.getWidth() == stage.getWidth() && bounds.getHeight() == stage.getHeight()) {
                if (this.backupWindowBounds != null) {
                    stage.setX(this.backupWindowBounds.getMinX());
                    stage.setY(this.backupWindowBounds.getMinY());
                    stage.setWidth(this.backupWindowBounds.getWidth());
                    stage.setHeight(this.backupWindowBounds.getHeight());
                }
            } else {
                this.backupWindowBounds = new Rectangle2D(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight());
                double newStageY = screen.getVisualBounds().getMinY();
                stage.setX(screen.getVisualBounds().getMinX());
                stage.setY(newStageY);
                stage.setWidth(screen.getVisualBounds().getWidth());
                stage.setHeight(screen.getVisualBounds().getHeight());
            }
        }
    }

    protected void close() {
        FrameEvent evt = new FrameEvent(this, FrameEvent.CLOSING);
        Event.fireEvent((EventTarget)this, (Event)evt);
        if (!evt.isConsumed()) {
            if (!this.isLightweight()) {
                ((Stage)this.getScene().getWindow()).close();
            }
            Event.fireEvent((EventTarget)this, (Event)new FrameEvent(this, FrameEvent.CLOSED));
        }
    }

    protected void minimize() {
        if (!this.isLightweight()) {
            ((Stage)this.getScene().getWindow()).setIconified(true);
        }
    }

    @Override
    public final void setMaximizable(boolean maximizeable) {
        this.maximizable.set(maximizeable);
    }

    public final BooleanProperty maximizableProperty() {
        return this.maximizable;
    }

    public final boolean isMaximizable() {
        return this.maximizable.get();
    }

    @Override
    public final void setMinimizable(boolean minimizable) {
        this.minimizable.set(minimizable);
    }

    public final BooleanProperty minimizableProperty() {
        return this.minimizable;
    }

    public final boolean isMinimizable() {
        return this.minimizable.get();
    }

    @Override
    public final void setResizeable(boolean resizable) {
        this.resizeable.set(resizable);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.resizeLeft != null) {
            this.resizeLeft.resizeRelocate(0.0, 10.0, 10.0, this.getHeight() - (double)(2 * 10));
            this.resizeLeft.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeRight != null) {
            this.resizeRight.resizeRelocate(this.getWidth() - 10.0, 10.0, 10.0, this.getHeight() - (double)(2 * 10));
            this.resizeRight.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeTop != null) {
            this.resizeTop.resizeRelocate(10.0, 0.0, this.getWidth() - 10.0, 10.0);
            this.resizeTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeBottom != null) {
            this.resizeBottom.resizeRelocate(10.0, this.getHeight() - 10.0, this.getWidth() - 10.0, 10.0);
            this.resizeBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerRightBottom != null) {
            this.resizeCornerRightBottom.resizeRelocate(this.getWidth() - 10.0, this.getHeight() - 10.0, 10.0, 10.0);
            this.resizeCornerRightBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerRightTop != null) {
            this.resizeCornerRightTop.resizeRelocate(this.getWidth() - 10.0, 0.0, 10.0, 10.0);
            this.resizeCornerRightTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerLeftBottom != null) {
            this.resizeCornerLeftBottom.resizeRelocate(0.0, this.getHeight() - 10.0, 10.0, 10.0);
            this.resizeCornerLeftBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerLeftTop != null) {
            this.resizeCornerLeftTop.resizeRelocate(0.0, 0.0, 10.0, 10.0);
            this.resizeCornerLeftTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
    }

    public final ReadOnlyBooleanProperty lightweightProperty() {
        return this.lightweight.getReadOnlyProperty();
    }

    public final boolean isLightweight() {
        return this.lightweightProperty().get();
    }

    static enum Location {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;

    }

    class ResizeHandler
    implements EventHandler<MouseEvent> {
        private double width;
        private double height;
        private double x;
        private double y;
        private Point2D dragAnchor;
        private Location[] locations;

        public ResizeHandler(Location ... locations) {
            this.locations = locations;
        }

        public void handle(MouseEvent event) {
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_PRESSED) {
                this.x = ResizeableFramePane.this.getStage().getX();
                this.y = ResizeableFramePane.this.getStage().getY();
                this.width = ResizeableFramePane.this.getStage().getWidth();
                this.height = ResizeableFramePane.this.getStage().getHeight();
                this.dragAnchor = new Point2D(event.getScreenX(), event.getScreenY());
            } else if (type == MouseEvent.MOUSE_DRAGGED && !ResizeableFramePane.this.isLightweight()) {
                double deltaX = event.getScreenX() - this.dragAnchor.getX();
                double deltaY = event.getScreenY() - this.dragAnchor.getY();
                Location[] locationArray = this.locations;
                int n = this.locations.length;
                int n2 = 0;
                while (n2 < n) {
                    Location l = locationArray[n2];
                    switch (l) {
                        case TOP: {
                            ResizeableFramePane.this.getStage().setY(this.y + (double)((int)deltaY));
                            ResizeableFramePane.this.getStage().setHeight(this.height + (double)(-1 * (int)deltaY));
                            break;
                        }
                        case BOTTOM: {
                            ResizeableFramePane.this.getStage().setHeight(this.height + deltaY);
                            break;
                        }
                        case LEFT: {
                            ResizeableFramePane.this.getStage().setX(this.x + (double)((int)deltaX));
                            ResizeableFramePane.this.getStage().setWidth(this.width + (double)(-1 * (int)deltaX));
                            break;
                        }
                        case RIGHT: {
                            ResizeableFramePane.this.getStage().setWidth(this.width + deltaX);
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

