/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.hover;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXEnumProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverProvider;

public class FXHoverProvider
extends XbaseHoverProvider {
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    private JavadocHoverWrapper javadocHover = new JavadocHoverWrapper();

    private IType getJDTType(JvmType jvmTypeRef) {
        try {
            IJavaProject javaProject = this.javaProjectProvider.getJavaProject(jvmTypeRef.eResource().getResourceSet());
            return javaProject.findType(jvmTypeRef.getQualifiedName());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IEObjectHoverProvider.IInformationControlCreatorProvider getHoverInfo(EObject object, ITextViewer viewer, IRegion region) {
        if (object instanceof Element) {
            IType t;
            Element e = (Element)object;
            if (e.getType() != null && (t = this.getJDTType(e.getType().getType())) != null) {
                return this.createHover((IJavaElement)t, object, viewer, region);
            }
        } else if (object instanceof Property) {
            IFXProperty fxp;
            IFXClass fxClass;
            IType t;
            Element e;
            Property p = (Property)object;
            if (p.eContainer() instanceof Element && (e = (Element)p.eContainer()).getType() != null && (t = this.getJDTType(e.getType().getType())) != null && (fxClass = FXPlugin.getClassmodel().findClass(t.getJavaProject(), t)) != null && (fxp = fxClass.getProperty(p.getName())) != null) {
                return this.createHover(fxp.getJavaElement(), object, viewer, region);
            }
        } else if (object instanceof StaticCallValueProperty) {
            IFXProperty fxp;
            IFXClass fxClass;
            IType t;
            StaticCallValueProperty sp = (StaticCallValueProperty)object;
            if (sp.getType() != null && (t = this.getJDTType(sp.getType().getType())) != null && (fxClass = FXPlugin.getClassmodel().findClass(t.getJavaProject(), t)) != null && (fxp = fxClass.getStaticProperty(sp.getName())) != null) {
                return this.createHover(fxp.getJavaElement(), object, viewer, region);
            }
        } else if (object instanceof StaticValueProperty) {
            IFXProperty fxp;
            IFXClass fxClass;
            IType t;
            StaticValueProperty sp = (StaticValueProperty)object;
            EObject eo = sp.eContainer();
            Element target = null;
            while (eo.eContainer() != null) {
                if (eo.eContainer() instanceof Element) {
                    target = (Element)eo.eContainer();
                    break;
                }
                eo = eo.eContainer();
            }
            if (target != null && target.getType() != null && (t = this.getJDTType(target.getType().getType())) != null && (fxClass = FXPlugin.getClassmodel().findClass(t.getJavaProject(), t)) != null && (fxp = fxClass.getStaticProperty(sp.getName())) != null) {
                return this.createHover(fxp.getJavaElement(), object, viewer, region);
            }
        } else if (object instanceof ValueProperty) {
            IFXProperty fxp;
            IFXClass fxClass;
            IType t;
            Element e;
            Property p;
            SimpleValueProperty sp;
            if (object instanceof ControllerHandledValueProperty) {
                IFXCtrlEventMethod fxp2;
                IFXCtrlClass fxClass2;
                IType t2;
                ComponentDefinition def;
                ControllerHandledValueProperty cp = (ControllerHandledValueProperty)object;
                Model m = (Model)object.eResource().getContents().get(0);
                if (m != null && (def = m.getComponentDef()) != null && def.getController() != null && def.getController().getType() != null && (t2 = this.getJDTType(def.getController().getType())) != null && (fxClass2 = FXPlugin.getClassmodel().findCtrlClass(t2.getJavaProject(), t2)) != null && (fxp2 = (IFXCtrlEventMethod)fxClass2.getAllEventMethods().get(cp.getMethodname())) != null) {
                    return this.createHover(fxp2.getJavaElement(), object, viewer, region);
                }
            } else if (object instanceof SimpleValueProperty && (sp = (SimpleValueProperty)object).eContainer() instanceof Property && sp.getStringValue() != null && (p = (Property)sp.eContainer()).eContainer() instanceof Element && (e = (Element)p.eContainer()).getType() != null && (t = this.getJDTType(e.getType().getType())) != null && (fxClass = FXPlugin.getClassmodel().findClass(t.getJavaProject(), t)) != null && (fxp = fxClass.getProperty(p.getName())) instanceof IFXEnumProperty) {
                IType enumType = ((IFXEnumProperty)fxp).getEnumType();
                try {
                    IField[] iFieldArray = enumType.getFields();
                    int n = iFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField f = iFieldArray[n2];
                        if (Flags.isEnum((int)f.getFlags()) && f.getElementName().equals(sp.getStringValue())) {
                            return this.createHover((IJavaElement)f, object, viewer, region);
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return super.getHoverInfo(object, viewer, region);
    }

    private IEObjectHoverProvider.IInformationControlCreatorProvider createHover(IJavaElement javaElement, EObject eObject, ITextViewer viewer, IRegion region) {
        this.javadocHover.setJavaElement(javaElement);
        final Object hoverInfo2 = this.javadocHover.getHoverInfo2(viewer, region);
        return new IEObjectHoverProvider.IInformationControlCreatorProvider(){

            public IInformationControlCreator getHoverControlCreator() {
                return FXHoverProvider.this.javadocHover.getHoverControlCreator();
            }

            public Object getInfo() {
                return hoverInfo2;
            }
        };
    }

    protected boolean hasHover(EObject o) {
        return super.hasHover(o);
    }

    static class JavadocHoverWrapper
    extends JavadocHover {
        IJavaElement currentElement;

        JavadocHoverWrapper() {
        }

        void setJavaElement(IJavaElement element) {
            this.currentElement = element;
        }

        protected IJavaElement[] getJavaElementsAt(ITextViewer textViewer, IRegion hoverRegion) {
            return new IJavaElement[]{this.currentElement};
        }
    }
}

