/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.function.Function;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.image.Image;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.cache.Cache;
import org.eclipse.fx.ui.controls.image.SingleMultiDimensionImage;

public interface MultiDimensionImage {
    public double getRatio();

    public ReadOnlyDoubleProperty ratioProperty();

    public ReadOnlyObjectProperty<Image> imageProperty();

    public void updateDimension(double var1, double var3);

    public static MultiDimensionImage singleDimension(Image image) {
        return new SingleMultiDimensionImage(image);
    }

    public static <O> MultiDimensionImage singleDimension(ThreadSynchronize threadSynchronize, Image placeholder, O data, Function<O, Image> imageComputer) {
        return new SingleMultiDimensionImage(threadSynchronize, placeholder, data, imageComputer, null);
    }

    public static <O> MultiDimensionImage singleDimension(ThreadSynchronize threadSynchronize, Image placeholder, O data, Function<O, Image> imageComputer, Cache<O, Image> cache) {
        return new SingleMultiDimensionImage(threadSynchronize, placeholder, data, imageComputer, cache);
    }
}

