/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.events.TextPositionEvent;

public class TextPositionSupport {
    private StyledTextArea textArea;
    private Region control;

    public TextPositionSupport(Region control, StyledTextArea textArea) {
        this.control = control;
        this.textArea = textArea;
    }

    protected void install() {
        this.control.addEventHandler(MouseEvent.MOUSE_CLICKED, this::onMouseEvent);
        this.control.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMouseEvent);
        this.control.addEventHandler(MouseEvent.DRAG_DETECTED, this::onMouseEvent);
        this.control.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::onMouseEvent);
        this.control.addEventHandler(MouseEvent.MOUSE_RELEASED, this::onMouseEvent);
        this.control.addEventFilter(MouseEvent.MOUSE_MOVED, this::onMouseEvent);
    }

    public static TextPositionSupport install(Region control, StyledTextArea textArea) {
        TextPositionSupport support = new TextPositionSupport(control, textArea);
        support.install();
        return support;
    }

    private void onMouseEvent(MouseEvent event) {
        Event.fireEvent((EventTarget)this.textArea, (Event)new TextPositionEvent(event, this.computeCursorOffset(event)));
    }

    protected int computeCursorOffset(MouseEvent event) {
        return this.textArea.getOffsetAtPosition(event.getX(), event.getY());
    }
}

