/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryMethodSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationValueBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class JvmExecutableBuilder
extends MethodVisitor
implements Opcodes {
    protected final Proxies proxies;
    private JvmDeclaredType declarator;
    private final JvmExecutable result;
    private final int offset;
    private String returnType;

    public JvmExecutableBuilder(JvmDeclaredType declarator, int initialOffset, Map<String, JvmTypeParameter> typeParameters, Proxies proxies, int access, String name, String desc, String signature, String[] exceptions) {
        block10: {
            List<BinaryGenericTypeSignature> exceptionSignatures;
            block9: {
                int myOffset;
                StringBuilder fqName;
                super(589824);
                this.proxies = proxies;
                this.declarator = declarator;
                if (this.isConstructor(name)) {
                    this.result = TypesFactory.eINSTANCE.createJvmConstructor();
                    String declaratorIdentifier = declarator.getIdentifier();
                    String simpleName = declarator.getSimpleName();
                    fqName = new StringBuilder(declaratorIdentifier.length() + 1 + simpleName.length() + desc.length());
                    fqName.append(declaratorIdentifier);
                    fqName.append('.');
                    fqName.append(simpleName);
                    this.result.setSimpleName(simpleName);
                    this.offset = initialOffset;
                } else {
                    JvmOperation operation = TypesFactory.eINSTANCE.createJvmOperation();
                    this.result = operation;
                    String declaratorIdentifier = declarator.getIdentifier();
                    fqName = new StringBuilder(declaratorIdentifier.length() + 1 + name.length() + desc.length());
                    fqName.append(declaratorIdentifier);
                    fqName.append('.');
                    fqName.append(name);
                    this.result.setSimpleName(name);
                    this.offset = 0;
                    operation.setAbstract((access & 0x400) != 0);
                    operation.setFinal((access & 0x10) != 0);
                    operation.setStatic((access & 8) != 0);
                    operation.setSynchronized((access & 0x20) != 0);
                    operation.setStrictFloatingPoint((access & 0x800) != 0);
                    operation.setNative((access & 0x100) != 0);
                    if (declarator.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)declarator).isInterface() && !operation.isAbstract() && !operation.isStatic()) {
                        operation.setDefault(true);
                    }
                }
                proxies.setVisibility(access, this.result);
                BinaryMethodSignature binarySignature = BinarySignatures.createMethodSignature(signature != null ? signature : desc);
                typeParameters = proxies.createTypeParameters(binarySignature, this.result, typeParameters);
                if (this.result.eClass() == TypesPackage.Literals.JVM_OPERATION) {
                    this.returnType = desc;
                    ((JvmOperation)this.result).setReturnType(proxies.createTypeReference(binarySignature.getReturnType(), typeParameters));
                }
                fqName.append('(');
                List<BinaryGenericTypeSignature> parameterTypes = binarySignature.getParameterTypes();
                int n = myOffset = signature == null ? this.offset : 0;
                if (parameterTypes.size() > myOffset) {
                    InternalEList parameters = (InternalEList)this.result.getParameters();
                    int i = myOffset;
                    while (i < parameterTypes.size()) {
                        if (i != myOffset) {
                            fqName.append(',');
                        }
                        BinaryTypeSignature parameterType = parameterTypes.get(i);
                        fqName.append(parameterType.getTypeErasure().toIdentifier());
                        parameters.addUnique((Object)this.createFormalParameter(parameterType, "arg" + (i - myOffset), this.result, typeParameters));
                        ++i;
                    }
                }
                fqName.append(')');
                this.result.internalSetIdentifier(fqName.toString());
                proxies.setVisibility(access, this.result);
                this.result.setVarArgs((access & 0x80) != 0);
                this.result.setDeprecated((access & 0x20000) != 0);
                exceptionSignatures = binarySignature.getExceptionTypes();
                if (exceptionSignatures.size() != 0) break block9;
                if (exceptions == null) break block10;
                InternalEList resultExceptions = (InternalEList)this.result.getExceptions();
                int i = 0;
                int max = exceptions.length;
                while (i < max) {
                    resultExceptions.addUnique((Object)proxies.createTypeReference(BinarySignatures.createObjectTypeSignature(exceptions[i]), typeParameters));
                    ++i;
                }
                break block10;
            }
            InternalEList resultExceptions = (InternalEList)this.result.getExceptions();
            int i = 0;
            int max = exceptionSignatures.size();
            while (i < max) {
                resultExceptions.addUnique((Object)proxies.createTypeReference(exceptionSignatures.get(i), typeParameters));
                ++i;
            }
        }
    }

    public void visitAttribute(Attribute attr) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new JvmAnnotationReferenceBuilder((InternalEList<JvmAnnotationReference>)((InternalEList)this.result.getAnnotations()), desc, this.proxies);
    }

    public void visitEnd() {
        InternalEList members = (InternalEList)this.declarator.getMembers();
        members.addUnique((Object)this.result);
    }

    protected JvmFormalParameter createFormalParameter(BinaryTypeSignature parameterType, String paramName, JvmMember container, Map<String, JvmTypeParameter> typeParameters) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(paramName);
        result.setParameterType(this.proxies.createTypeReference(parameterType, typeParameters));
        return result;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new JvmAnnotationValueBuilder(this.proxies){
            int array;
            {
                this.array = 0;
            }

            public void visitEnd() {
                block14: {
                    block10: {
                        JvmOperation operation;
                        block11: {
                            block13: {
                                block12: {
                                    if (this.array != 0) break block10;
                                    operation = (JvmOperation)JvmExecutableBuilder.this.result;
                                    if (this.result != null) break block11;
                                    if (!JvmExecutableBuilder.this.returnType.equals("()[Ljava/lang/Class;")) break block12;
                                    this.result = TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
                                    break block11;
                                }
                                if (JvmExecutableBuilder.this.returnType.length() != 4) break block13;
                                switch (JvmExecutableBuilder.this.returnType.charAt(3)) {
                                    case 'B': {
                                        this.result = TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
                                        break block11;
                                    }
                                    case 'C': {
                                        this.result = TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
                                        break block11;
                                    }
                                    case 'D': {
                                        this.result = TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
                                        break block11;
                                    }
                                    case 'F': {
                                        this.result = TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
                                        break block11;
                                    }
                                    case 'I': {
                                        this.result = TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
                                        break block11;
                                    }
                                    case 'J': {
                                        this.result = TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
                                        break block11;
                                    }
                                    case 'S': {
                                        this.result = TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
                                        break block11;
                                    }
                                    case 'Z': {
                                        this.result = TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
                                        break block11;
                                    }
                                    default: {
                                        throw new IllegalArgumentException(JvmExecutableBuilder.this.returnType.toString());
                                    }
                                }
                            }
                            this.result = TypesFactory.eINSTANCE.createJvmCustomAnnotationValue();
                        }
                        this.result.setOperation(operation);
                        operation.setDefaultValue(this.result);
                        break block14;
                    }
                    --this.array;
                }
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                ++this.array;
                return this;
            }
        };
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        JvmFormalParameter formalParameter = (JvmFormalParameter)this.result.getParameters().get(parameter);
        return new JvmAnnotationReferenceBuilder((InternalEList<JvmAnnotationReference>)((InternalEList)formalParameter.getAnnotations()), desc, this.proxies);
    }

    public void visitCode() {
        throw new UnsupportedOperationException();
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        throw new UnsupportedOperationException();
    }

    public void visitInsn(int opcode) {
        throw new UnsupportedOperationException();
    }

    public void visitIntInsn(int opcode, int operand) {
        throw new UnsupportedOperationException();
    }

    public void visitVarInsn(int opcode, int var) {
        throw new UnsupportedOperationException();
    }

    public void visitTypeInsn(int opcode, String type) {
        throw new UnsupportedOperationException();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        throw new UnsupportedOperationException();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        throw new UnsupportedOperationException();
    }

    public void visitJumpInsn(int opcode, Label label) {
        throw new UnsupportedOperationException();
    }

    public void visitLabel(Label label) {
        throw new UnsupportedOperationException();
    }

    public void visitLdcInsn(Object cst) {
        throw new UnsupportedOperationException();
    }

    public void visitIincInsn(int var, int increment) {
        throw new UnsupportedOperationException();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        throw new UnsupportedOperationException();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        throw new UnsupportedOperationException();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        throw new UnsupportedOperationException();
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        throw new UnsupportedOperationException();
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        throw new UnsupportedOperationException();
    }

    public void visitLineNumber(int line, Label start) {
        throw new UnsupportedOperationException();
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        throw new UnsupportedOperationException();
    }

    private boolean isConstructor(String selector) {
        return selector.charAt(0) == '<' && selector.length() == 6;
    }
}

