/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@FinalFieldsConstructor
public class ClusteringStorageAwareResourceLoader {
    @Extension
    private final BuildContext context;

    public <T> Iterable<T> executeClustered(Iterable<URI> uris, Functions.Function1<? super Resource, ? extends T> operation) {
        ArrayList _xblockexpression = null;
        ArrayList loadedURIs = CollectionLiterals.newArrayList((Object[])new URI[0]);
        ArrayList sourceLevelURIs = CollectionLiterals.newArrayList((Object[])new URI[0]);
        ArrayList resources = CollectionLiterals.newArrayList((Object[])new Resource[0]);
        ArrayList result = CollectionLiterals.newArrayList((Object[])new Object[0]);
        for (URI uri : uris) {
            boolean _not;
            boolean _continueProcessing = this.context.getClusteringPolicy().continueProcessing((ResourceSet)this.context.getResourceSet(), uri, loadedURIs.size());
            boolean bl = _not = !_continueProcessing;
            if (_not) {
                Functions.Function1 _function = it -> operation.apply(it);
                List _map = ListExtensions.map((List)resources, (Functions.Function1)_function);
                Iterables.addAll((Collection)result, (Iterable)_map);
                resources.clear();
                this.clearResourceSet();
                loadedURIs.clear();
            }
            loadedURIs.add(uri);
            boolean _isSource = this.isSource(uri);
            if (_isSource) {
                boolean _isLoadedFromStorage;
                sourceLevelURIs.add(uri);
                Resource existingResource = this.context.getResourceSet().getResource(uri, false);
                if (existingResource instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)existingResource).isLoadedFromStorage())) {
                    ((StorageAwareResource)existingResource).unload();
                }
                SourceLevelURIsAdapter.setSourceLevelUris((ResourceSet)this.context.getResourceSet(), sourceLevelURIs);
            }
            Resource _resource = this.context.getResourceSet().getResource(uri, true);
            resources.add(_resource);
        }
        Functions.Function1 _function = it -> operation.apply(it);
        List _map = ListExtensions.map((List)resources, (Functions.Function1)_function);
        Iterables.addAll((Collection)result, (Iterable)_map);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected boolean isSource(URI uri) {
        IResourceServiceProvider provider = this.context.getResourceServiceProvider(uri);
        return provider instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)((Object)provider)).isSource(uri);
    }

    protected void clearResourceSet() {
        boolean wasDeliver = this.context.getResourceSet().eDeliver();
        try {
            this.context.getResourceSet().eSetDeliver(false);
            this.context.getResourceSet().getResources().clear();
        }
        finally {
            this.context.getResourceSet().eSetDeliver(wasDeliver);
        }
    }

    public ClusteringStorageAwareResourceLoader(BuildContext context) {
        this.context = context;
    }
}

