/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.lang.reflect.Field;

public class ReflectionUtil {
    public static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        Class<?> searchClass = clazz;
        Field field = null;
        while (field == null && searchClass != null) {
            try {
                field = searchClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                searchClass = searchClass.getSuperclass();
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(String.valueOf(clazz.getSimpleName()) + "." + name);
        }
        return field;
    }

    public static void setFieldValue(Object object, String name, Object value) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Could not set field value: " + object.getClass().getSimpleName() + "." + name, e);
        }
    }

    public static Object getFieldValue(Object object, String name) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Could not read field value: " + object.getClass().getSimpleName() + "." + name, e);
        }
    }
}

