/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.contentassist.IContextInformationValidator;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;

class ContextInformationPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private PopupWindow fContextInfoPopup;
    private BorderPane fRoot;
    private Label fContent;
    private IContextInformationValidator contextInfoValidator;
    private ChangeListener<Number> selectionChange = this::onSelectionChange;

    public ContextInformationPopup(IContextInformationValidator contextInfoValidator, ITextViewer viewer) {
        this.contextInfoValidator = contextInfoValidator;
        this.fViewer = viewer;
        this.fContextInfoPopup = new PopupWindow(){};
        this.fContextInfoPopup.setAutoFix(false);
        this.fContextInfoPopup.setAutoHide(true);
        viewer.getTextWidget().sceneProperty().addListener(e -> {
            if (viewer.getTextWidget().getScene() != null) {
                this.fContextInfoPopup.getScene().getStylesheets().setAll((Collection)viewer.getTextWidget().getScene().getStylesheets());
            }
        });
        if (viewer.getTextWidget().getScene() != null) {
            this.fContextInfoPopup.getScene().getStylesheets().setAll((Collection)viewer.getTextWidget().getScene().getStylesheets());
        }
        this.fRoot = new BorderPane();
        this.fRoot.getStyleClass().add((Object)"styled-text-hover");
        this.fContent = new Label();
        this.fRoot.setCenter((Node)this.fContent);
        this.fContent.getStyleClass().add((Object)"context-info");
        this.fContextInfoPopup.getScene().setRoot((Parent)this.fRoot);
        this.fContextInfoPopup.setOnShowing(this::subscribe);
        this.fContextInfoPopup.setOnHidden(this::unsubscribe);
    }

    private void subscribe(Event e) {
        this.fViewer.getTextWidget().caretOffsetProperty().addListener(this.selectionChange);
    }

    private void unsubscribe(Event e) {
        this.fViewer.getTextWidget().caretOffsetProperty().removeListener(this.selectionChange);
    }

    private void onSelectionChange(Observable x, Number oldSelection, Number newSelection) {
        int offset = this.fViewer.getTextWidget().caretOffsetProperty().get();
        if (this.contextInfoValidator != null) {
            if (!this.contextInfoValidator.isContextInformationValid(offset)) {
                this.fContextInfoPopup.hide();
            } else {
                CharSequence infoText = this.contextInfoValidator.getInformationDisplayString(offset);
                if (infoText != null) {
                    this.updateInfoText(infoText);
                }
            }
        }
    }

    public String showContextProposals(boolean autoActivated) {
        return "TODO";
    }

    private void updateInfoText(CharSequence infoText) {
        if (infoText instanceof StyledString) {
            this.fContent.setText("");
            this.fContent.setGraphic(Util.toNode((StyledString)((StyledString)infoText)));
        } else {
            this.fContent.setText(infoText.toString());
            this.fContent.setGraphic(null);
        }
    }

    public void showContextInformation(IContextInformation info, int offset) {
        CharSequence infoText;
        CharSequence charSequence = infoText = info == null ? null : info.getInformationDisplayString();
        if (infoText != null && infoText.length() > 0) {
            if (this.contextInfoValidator != null) {
                this.contextInfoValidator.install(info, this.fViewer, offset);
            }
            this.updateInfoText(infoText);
            Point2D locationAtOffset = this.fViewer.getTextWidget().getLocationAtOffset(offset, StyledTextArea.LineLocation.ABOVE);
            locationAtOffset = this.fViewer.getTextWidget().localToScreen(locationAtOffset);
            if (locationAtOffset != null) {
                this.fContent.applyCss();
                double y = locationAtOffset.getY() - this.fContent.prefHeight(-1.0);
                this.fContextInfoPopup.show(this.fViewer.getTextWidget().getScene().getWindow(), locationAtOffset.getX(), y);
            }
        } else {
            this.fContextInfoPopup.hide();
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        return false;
    }
}

