/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.grammarAccess.FragmentFakingEcoreResourceFactoryImpl;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;
import org.eclipse.xtext.generator.grammarAccess.ResourceSaveIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.RuleNames;

public class GrammarAccessFragment
extends AbstractGeneratorFragment {
    private static final Logger log = Logger.getLogger(GrammarAccessFragment.class);
    private String xmlVersion = null;

    @Override
    protected String getTemplate() {
        return GrammarAccessFragment.class.getName().replaceAll("\\.", "::");
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.getNaming().getLineDelimiter());
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        BindFactory bindFactory = new BindFactory();
        if (!Strings.equal((String)"org.eclipse.xtext.common.Terminals", (String)grammar.getName())) {
            bindFactory.addTypeToInstance(ClassLoader.class.getName(), "getClass().getClassLoader()");
        }
        bindFactory.addTypeToType(IGrammarAccess.class.getName(), GrammarAccessUtil.getGrammarAccessFQName(grammar, this.getNaming()));
        return bindFactory.getBindings();
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        return new String[]{GrammarUtil.getNamespace((Grammar)grammar), String.valueOf(GrammarUtil.getNamespace((Grammar)grammar)) + ".services"};
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        String path;
        RuleNames.ensureAdapterInstalled((Grammar)grammar);
        super.generate(grammar, ctx);
        ResourceSaveIndicator isSaving = new ResourceSaveIndicator();
        Grammar copy = this.deepCopy(grammar, isSaving);
        ResourceSet set = copy.eResource().getResourceSet();
        if (this.xmlVersion == null) {
            path = GrammarUtil.getClasspathRelativePathToBinGrammar((Grammar)copy);
        } else {
            log.warn((Object)("'xmlVersion' has been specified for this " + GrammarAccessFragment.class.getSimpleName() + ". Therefore, the grammar is persisted as XMI and not as binary. This can be a performance drawback."));
            path = GrammarUtil.getClasspathRelativePathToXmi((Grammar)copy);
        }
        URI uri = URI.createURI((String)(String.valueOf(ctx.getOutput().getOutlet("SRC_GEN").getPath()) + "/" + path));
        Resource resource = set.createResource(uri, "");
        this.addAllGrammarsToResource(resource, copy, new HashSet<Grammar>());
        isSaving.set(Boolean.TRUE);
        HashMap saveOptions = Maps.newHashMap();
        if (resource instanceof XMLResource) {
            ((XMLResource)resource).setXMLVersion(this.getXmlVersion());
        } else if (resource instanceof BinaryResourceImpl) {
            saveOptions.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            saveOptions.put("DATA_CONVERTER", Boolean.TRUE);
        }
        try {
            try {
                resource.save((Map)saveOptions);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                isSaving.set(Boolean.FALSE);
            }
        }
        finally {
            isSaving.set(Boolean.FALSE);
        }
    }

    public Grammar deepCopy(Grammar grammar, ResourceSaveIndicator isSaving) {
        ResourceSetImpl cloneInto = new ResourceSetImpl();
        cloneInto.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new FragmentFakingEcoreResourceFactoryImpl(isSaving));
        ResourceSet set = EcoreUtil2.clone((ResourceSet)cloneInto, (ResourceSet)grammar.eResource().getResourceSet());
        Grammar copy = (Grammar)set.getResource(grammar.eResource().getURI(), true).getContents().get(0);
        return copy;
    }

    public void addAllGrammarsToResource(Resource resource, Grammar grammar, Set<Grammar> visitedGrammars) {
        if (!visitedGrammars.add(grammar)) {
            return;
        }
        resource.getContents().add((Object)grammar);
        this.replaceResourceURIsWithNsURIs(grammar, resource.getResourceSet());
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.addAllGrammarsToResource(resource, usedGrammar, visitedGrammars);
        }
    }

    public void replaceResourceURIsWithNsURIs(Grammar grammar, ResourceSet set) {
        for (AbstractMetamodelDeclaration metamodelDecl : grammar.getMetamodelDeclarations()) {
            ResourceSet packResourceSet;
            EPackage pack = metamodelDecl.getEPackage();
            Resource packResource = pack.eResource();
            if (packResource.getURI().toString().equals(pack.getNsURI()) || (packResourceSet = packResource.getResourceSet()) == null) continue;
            EPackage topMost = pack;
            while (topMost.getESuperPackage() != null && topMost.getESuperPackage().eResource() == topMost.eResource()) {
                topMost = topMost.getESuperPackage();
            }
            if (packResource.getContents().contains((Object)topMost) && packResource.getContents().size() == 1) {
                if (!topMost.getEClassifiers().isEmpty()) {
                    packResource.setURI(URI.createURI((String)topMost.getNsURI()));
                } else {
                    this.moveSubpackagesToNewResource(topMost, set);
                }
            }
            if (topMost.eResource().getURI().toString().equals(topMost.getNsURI())) continue;
            this.movePackageToNewResource(topMost, set);
        }
    }

    public void moveSubpackagesToNewResource(EPackage pack, ResourceSet set) {
        int i = pack.getESubpackages().size() - 1;
        while (i >= 0) {
            EPackage sub = (EPackage)pack.getESubpackages().get(i);
            if (sub.eResource() == pack.eResource()) {
                if (sub.getEClassifiers().isEmpty()) {
                    this.moveSubpackagesToNewResource(sub, set);
                } else {
                    this.movePackageToNewResource(sub, set);
                    pack.getESubpackages().remove(i);
                }
            }
            --i;
        }
    }

    protected void movePackageToNewResource(EPackage pack, ResourceSet set) {
        Resource resource = set.createResource(URI.createURI((String)"___temp___.ecore"), "");
        resource.setURI(URI.createURI((String)pack.getNsURI()));
        resource.getContents().add((Object)pack);
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public String getXmlVersion() {
        return this.xmlVersion == null ? "1.0" : this.xmlVersion;
    }
}

