/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.util.Duration;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={org.eclipse.fx.ui.services.sync.UISynchronize.class, UISynchronize.class, ThreadSynchronize.class})
public class UISynchronizeImpl
extends UISynchronize
implements org.eclipse.fx.ui.services.sync.UISynchronize {
    private LoggerFactory factory;
    private Logger logger;

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setLoggerFactory(LoggerFactory factory) {
        this.factory = factory;
        this.logger = null;
    }

    public void unsetLoggerFactory(LoggerFactory factory) {
        if (this.factory == factory) {
            this.factory = null;
            this.logger = null;
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.factory.createLogger(((Object)((Object)this)).getClass().getName());
        }
        return this.logger;
    }

    public <V> V syncExec(Callable<V> callable, V defaultValue) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        try {
            Object v = task.get();
            return v;
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLogger().error("Unable to wait until the task is completed", (Throwable)e);
        }
        finally {
            task.cancel(true);
        }
        return defaultValue;
    }

    public void syncExec(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            Platform.runLater(task);
            try {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.getLogger().error("Unable to wait until the task is completed", (Throwable)e);
                    task.cancel(true);
                }
            }
            finally {
                task.cancel(true);
            }
        }
    }

    public <V> Future<V> asyncExec(Callable<V> callable) {
        FutureTask<V> task = new FutureTask<V>(callable);
        Platform.runLater(task);
        return task;
    }

    public void asyncExec(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    public Subscription scheduleExecution(long delay, Runnable runnable) {
        final AtomicBoolean b = new AtomicBoolean(true);
        final Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), a -> {
            if (b.get()) {
                runnable.run();
            }
        }, new KeyValue[0])});
        t.play();
        return new Subscription(){

            public void dispose() {
                b.set(false);
                t.stop();
            }
        };
    }

    public <T> CompletableFuture<T> scheduleExecution(long delay, Callable<T> runnable) {
        CompletableFuture future = new CompletableFuture();
        Timeline t = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)delay), a -> {
            try {
                if (!future.isCancelled()) {
                    future.complete(runnable.call());
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }, new KeyValue[0])});
        t.play();
        return future;
    }
}

