/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collator
implements Comparator<Object>,
Cloneable {
    private final java.text.Collator collator;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int QUATERNARY = 3;
    public static final int IDENTICAL = 2;
    public static final int FULL_DECOMPOSITION = 2;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    private transient boolean isFrozen = false;

    private Collator(java.text.Collator delegate) {
        this.collator = delegate;
    }

    protected Collator() {
        this.collator = null;
    }

    public void setStrength(int newStrength) {
        if (this.isFrozen) {
            throw new UnsupportedOperationException("Attempt to modify a frozen Collator instance.");
        }
        this.collator.setStrength(newStrength);
    }

    public void setDecomposition(int decomposition) {
        if (this.isFrozen) {
            throw new UnsupportedOperationException("Attempt to modify a frozen Collator instance.");
        }
        this.collator.setDecomposition(decomposition);
    }

    public static final Collator getInstance() {
        return new Collator(java.text.Collator.getInstance());
    }

    public Object clone() throws CloneNotSupportedException {
        return new Collator((java.text.Collator)this.collator.clone());
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public Collator freeze() {
        this.isFrozen = true;
        return this;
    }

    public Collator cloneAsThawed() {
        try {
            Collator other = (Collator)super.clone();
            other.isFrozen = false;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Collator getInstance(ULocale locale) {
        return Collator.getInstance(locale.toLocale());
    }

    public static final Collator getInstance(Locale locale) {
        return new Collator(java.text.Collator.getInstance(locale));
    }

    public static Locale[] getAvailableLocales() {
        return java.text.Collator.getAvailableLocales();
    }

    public static final ULocale[] getAvailableULocales() {
        Locale[] locales = java.text.Collator.getAvailableLocales();
        ULocale[] ulocales = new ULocale[locales.length];
        int i = 0;
        while (i < locales.length) {
            ulocales[i] = ULocale.forLocale(locales[i]);
            ++i;
        }
        return ulocales;
    }

    public static final String[] getKeywords() {
        return new String[0];
    }

    public static final String[] getKeywordValues(String keyword) {
        return new String[0];
    }

    public int getStrength() {
        return this.collator.getStrength();
    }

    public int getDecomposition() {
        return this.collator.getDecomposition();
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    @Override
    public int compare(String source, String target) {
        return this.collator.compare(source, target);
    }

    @Override
    public int compare(Object source, Object target) {
        return this.compare((String)source, (String)target);
    }

    public CollationKey getCollationKey(String source) {
        return new CollationKey(this.collator.getCollationKey(source));
    }

    public String toString() {
        return this.collator.toString();
    }

    @Override
    public boolean equals(Object rhs) {
        try {
            return this.collator.equals(((Collator)rhs).collator);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.collator.hashCode();
    }
}

