/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.fx.ui.workbench.base.rendering.AbstractRenderer;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPerspectiveStack;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPlaceholderWidget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BasePerspectiveStackRenderer<N, I, IC>
extends BaseRenderer<MPerspectiveStack, WPerspectiveStack<N, I, IC>> {
    @Inject
    RendererFactory factory;
    boolean inLazyInit;

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPerspectiveStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPerspectiveStack && BasePerspectiveStackRenderer.this == (parent = (MPerspectiveStack)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BasePerspectiveStackRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BasePerspectiveStackRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MPerspectiveStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPerspectiveStack && BasePerspectiveStackRenderer.this == (parent = (MPerspectiveStack)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BasePerspectiveStackRenderer.this.handleSelectedElement(parent, (MPerspective)oldValue, (MPerspective)newValue);
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                MElementContainer parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = changedObj.getParent()) != null && BasePerspectiveStackRenderer.this == parent.getRenderer()) {
                    MPerspectiveStack stack = (MPerspectiveStack)parent;
                    String eventType = (String)event.getProperty("EventType");
                    if ("SET".equals(eventType)) {
                        Boolean newValue = (Boolean)event.getProperty("NewValue");
                        if (newValue.booleanValue()) {
                            BasePerspectiveStackRenderer.this.childRendered(stack, changedObj);
                        } else {
                            BasePerspectiveStackRenderer.this.hideChild(stack, changedObj);
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void initWidget(final MPerspectiveStack element, WPerspectiveStack<N, I, IC> widget) {
        super.initWidget(element, widget);
        widget.setMouseSelectedItemCallback(new WCallback<WPerspectiveStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WPerspectiveStack.WStackItem<I, IC> param) {
                if (param.getDomElement() != null) {
                    BasePerspectiveStackRenderer.this.activatationJob(param.getDomElement(), true);
                }
                return null;
            }
        });
        widget.setKeySelectedItemCallback(new WCallback<WPerspectiveStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WPerspectiveStack.WStackItem<I, IC> param) {
                if (param.getDomElement() != null) {
                    BasePerspectiveStackRenderer.this.activatationJob(param.getDomElement(), false);
                }
                return null;
            }
        });
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                if (param.booleanValue() && element.getSelectedElement() != null) {
                    BasePerspectiveStackRenderer.this.activatationJob((MPerspective)element.getSelectedElement(), true);
                }
                return null;
            }
        });
    }

    private void activatationJob(MPerspective p, boolean focus) {
    }

    @Override
    public void doProcessContent(MPerspectiveStack element) {
        WPerspectiveStack stack = (WPerspectiveStack)this.getWidget((MUIElement)element);
        ArrayList items = new ArrayList();
        WPerspectiveStack.WStackItem<I, IC> initalItem = null;
        for (MPerspective e : element.getChildren()) {
            AbstractRenderer renderer = this.factory.getRenderer((MUIElement)e);
            if (renderer == null || !e.isToBeRendered() || !e.isVisible()) continue;
            WPerspectiveStack.WStackItem<I, IC> item = this.createStackItem(stack, e, renderer);
            items.add(item);
            if (e != element.getSelectedElement()) continue;
            initalItem = item;
        }
        if (!items.isEmpty()) {
            if (initalItem == null || items.size() == 1 || items.get(0) == initalItem) {
                stack.addItems(items);
            } else {
                stack.addItem(initalItem);
                if (items.get(items.size() - 1) == initalItem) {
                    stack.addItems(0, items.subList(0, items.size() - 1));
                } else {
                    int idx = items.indexOf(initalItem);
                    stack.addItems(0, items.subList(0, idx));
                    stack.addItems(items.subList(idx + 1, items.size()));
                }
            }
        }
        if (element.getSelectedElement() != null) {
            this.handleSelectedElement(element, null, (MPerspective)element.getSelectedElement());
        } else if (!element.getChildren().isEmpty()) {
            element.setSelectedElement((MUIElement)((MPerspective)element.getChildren().get(0)));
        }
    }

    private WPerspectiveStack.WStackItem<I, IC> createStackItem(WPerspectiveStack<N, I, IC> stack, final MPerspective e, AbstractRenderer<MPerspective, ?> renderer) {
        IEclipseContext context = renderer.setupRenderingContext((MUIElement)e);
        WPerspectiveStack.WStackItem item = (WPerspectiveStack.WStackItem)ContextInjectionFactory.make(stack.getStackItemClass(), (IEclipseContext)context);
        item.setDomElement(e);
        item.setInitCallback(new WCallback<WPerspectiveStack.WStackItem<I, IC>, IC>(){

            @Override
            public IC call(WPerspectiveStack.WStackItem<I, IC> param) {
                BasePerspectiveStackRenderer.this.inLazyInit = true;
                try {
                    WLayoutedWidget widget = (WLayoutedWidget)BasePerspectiveStackRenderer.this.engineCreateWidget(e);
                    if (widget != null) {
                        Object object = widget.getStaticLayoutNode();
                        return object;
                    }
                    return null;
                }
                finally {
                    BasePerspectiveStackRenderer.this.inLazyInit = false;
                }
            }
        });
        item.setOnCloseCallback(new WCallback<WPerspectiveStack.WStackItem<I, IC>, Boolean>(){

            @Override
            public Boolean call(WPerspectiveStack.WStackItem<I, IC> param) {
                return !BasePerspectiveStackRenderer.this.handleStackItemClose(e, param);
            }
        });
        return item;
    }

    void handleChildrenAddition(MPerspectiveStack parent, Collection<MPerspective> elements) {
        for (MPerspective element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            int idx = this.getRenderedIndex((MUIElement)parent, (MUIElement)element);
            AbstractRenderer renderer = this.factory.getRenderer((MUIElement)element);
            WPerspectiveStack stack = (WPerspectiveStack)this.getWidget((MUIElement)parent);
            WPerspectiveStack.WStackItem<I, IC> item = this.createStackItem((WPerspectiveStack)this.getWidget((MUIElement)parent), element, renderer);
            stack.addItems(idx, Collections.singletonList(item));
        }
    }

    void handleChildrenRemove(MPerspectiveStack parent, Collection<MPerspective> elements) {
        for (MPerspective element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    void handleSelectedElement(MPerspectiveStack parent, MPerspective oldElement, MPerspective newElement) {
        this.hideElementRecursive((MUIElement)oldElement);
        if (newElement != null) {
            WPerspectiveStack stack = (WPerspectiveStack)this.getWidget((MUIElement)parent);
            int idx = 0;
            for (WPerspectiveStack.WStackItem i : stack.getItems()) {
                if (i.getDomElement() == newElement) {
                    stack.selectItem(idx);
                    this.showElementRecursive((MUIElement)newElement);
                    return;
                }
                ++idx;
            }
            this.childRendered(parent, (MUIElement)newElement);
            stack.selectItem(parent.getChildren().indexOf(newElement));
            this.showElementRecursive((MUIElement)newElement);
        }
    }

    boolean handleStackItemClose(MPerspective e, WPerspectiveStack.WStackItem<I, IC> item) {
        return true;
    }

    public void childRendered(MPerspectiveStack parentElement, MUIElement element) {
        if (this.inLazyInit || this.inContentProcessing((MUIElement)parentElement) || !element.isVisible()) {
            return;
        }
        WPerspectiveStack stack = (WPerspectiveStack)this.getWidget((MUIElement)parentElement);
        for (WPerspectiveStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != element) continue;
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        AbstractRenderer renderer = this.factory.getRenderer(element);
        stack.addItems(idx, Collections.singletonList(this.createStackItem(stack, (MPerspective)element, renderer)));
    }

    public void hideChild(MPerspectiveStack container, MUIElement changedObj) {
        WPerspectiveStack stack = (WPerspectiveStack)this.getWidget((MUIElement)container);
        if (stack == null) {
            return;
        }
        WPerspectiveStack.WStackItem item = null;
        for (WPerspectiveStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != changedObj) continue;
            item = i;
            break;
        }
        if (item != null) {
            List<Object> l = Collections.singletonList(item);
            stack.removeItems(l);
        }
    }

    private void hideElementRecursive(MUIElement element) {
        block7: {
            block8: {
                MGenericStack container;
                block6: {
                    if (element == null || element.getWidget() == null) {
                        return;
                    }
                    if (element instanceof MPlaceholder) {
                        MPlaceholder ph = (MPlaceholder)element;
                        element = ph.getRef();
                    }
                    if (element instanceof MWindow && element.getWidget() != null) {
                        element.setVisible(false);
                    }
                    if (!(element instanceof MGenericStack)) break block6;
                    container = (MGenericStack)element;
                    MUIElement curSel = container.getSelectedElement();
                    this.hideElementRecursive(curSel);
                    break block7;
                }
                if (!(element instanceof MElementContainer)) break block7;
                container = (MElementContainer)element;
                for (MUIElement childElement : container.getChildren()) {
                    this.hideElementRecursive(childElement);
                }
                if (!(element instanceof MWindow)) break block8;
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.hideElementRecursive((MUIElement)w);
                }
                break block7;
            }
            if (!(element instanceof MPerspective)) break block7;
            for (MWindow w : ((MPerspective)element).getWindows()) {
                this.hideElementRecursive((MUIElement)w);
            }
        }
    }

    private void showElementRecursive(MUIElement element) {
        block17: {
            block16: {
                IEclipseContext context;
                if (!element.isToBeRendered()) {
                    return;
                }
                if (element instanceof MPlaceholder && element.getWidget() != null) {
                    MPlaceholder ph = (MPlaceholder)element;
                    MUIElement ref = ph.getRef();
                    if (ref.getCurSharedRef() != ph) {
                        ref.setCurSharedRef(ph);
                        WPlaceholderWidget placeholder = (WPlaceholderWidget)ph.getWidget();
                        WLayoutedWidget content = (WLayoutedWidget)ref.getWidget();
                        placeholder.setContent(content);
                    }
                    element = ref;
                }
                if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
                    IEclipseContext newParentContext = this.modelService.getContainingContext(element);
                    if (context.getParent() != newParentContext) {
                        context.setParent(newParentContext);
                    }
                }
                if (element instanceof MWindow && element.getWidget() != null) {
                    int visCount = 0;
                    for (MUIElement kid : ((MWindow)element).getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        ++visCount;
                    }
                    if (visCount > 0) {
                        element.setVisible(true);
                    }
                }
                if (!(element instanceof MGenericStack)) break block16;
                MGenericStack container = (MGenericStack)element;
                MUIElement curSel = container.getSelectedElement();
                if (curSel == null && container.getChildren().size() > 0) {
                    curSel = (MUIElement)container.getChildren().get(0);
                }
                if (curSel == null) break block17;
                this.showElementRecursive(curSel);
                break block17;
            }
            if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                MUIElement[] mUIElementArray = container.getChildren().toArray(new MUIElement[0]);
                int n = mUIElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MUIElement childElement = mUIElementArray[n2];
                    this.showElementRecursive(childElement);
                    ++n2;
                }
                if (element instanceof MWindow) {
                    for (MWindow w : ((MWindow)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w);
                    }
                } else if (element instanceof MPerspective) {
                    for (MWindow w : ((MPerspective)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w);
                    }
                }
            }
        }
    }
}

