/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;

public class ComputeProjectOrder {
    private ComputeProjectOrder() {
    }

    static <T> VertexOrder<T> computeVertexOrder(SortedSet<T> vertexes, List<T[]> references, Class<T> clazz) {
        Digraph<T> g1 = ComputeProjectOrder.computeGraph(vertexes, references, clazz);
        return ComputeProjectOrder.computeVertexOrder(g1, clazz);
    }

    public static <T> VertexOrder<T> computeVertexOrder(Digraph<T> g1, Class<T> clazz) {
        Object[][] knots;
        Assert.isNotNull(g1);
        Digraph g2 = new Digraph(clazz);
        List<T> resortedVertexes = g1.idsByDFSFinishTime(false);
        for (T t : resortedVertexes) {
            g2.addVertex(t);
        }
        for (Digraph.Vertex vertex : g1.vertexList) {
            for (Digraph.Vertex adjacent : vertex.adjacent) {
                g2.addEdge(adjacent.id, vertex.id);
            }
        }
        g2.freeze();
        List<Object> list = g2.idsByDFSFinishTime(true);
        Object[] orderedVertexes = (Object[])Array.newInstance(clazz, list.size());
        list.toArray(orderedVertexes);
        boolean hasCycles = g2.containsCycles();
        if (hasCycles) {
            List<T[]> knotList = g2.nonTrivialComponents();
            Class<?> arrayClass = Array.newInstance(clazz, 0).getClass();
            knots = (Object[][])Array.newInstance(arrayClass, knotList.size());
            knotList.toArray((T[])knots);
        } else {
            knots = (Object[][])Array.newInstance(clazz, 0, 0);
        }
        return new VertexOrder<Object>(orderedVertexes, hasCycles, knots);
    }

    static <T> VertexOrder<T> filterVertexOrder(VertexOrder<T> order, Predicate<T> filter, Class<T> clazz) {
        int filteredCount = 0;
        boolean[] filterMatches = new boolean[order.vertexes.length];
        int i = 0;
        while (i < order.vertexes.length) {
            filterMatches[i] = filter.test(order.vertexes[i]);
            if (filterMatches[i]) {
                ++filteredCount;
            }
            ++i;
        }
        if (filteredCount == 0) {
            return order;
        }
        Object[] reducedVertexes = (Object[])Array.newInstance(clazz, order.vertexes.length - filteredCount);
        int i2 = 0;
        int j = 0;
        while (i2 < order.vertexes.length) {
            if (!filterMatches[i2]) {
                reducedVertexes[j] = order.vertexes[i2];
                ++j;
            }
            ++i2;
        }
        ArrayList<Object[]> reducedKnots = new ArrayList<Object[]>(order.knots.length);
        T[][] TArray = order.knots;
        int n = order.knots.length;
        int n2 = 0;
        while (n2 < n) {
            T[] knot = TArray[n2];
            ArrayList knotList = new ArrayList(knot.length);
            T[] TArray2 = knot;
            int n3 = knot.length;
            int n4 = 0;
            while (n4 < n3) {
                Object vertex = TArray2[n4];
                if (!filter.test(vertex)) {
                    knotList.add(vertex);
                }
                ++n4;
            }
            if (knotList.size() > 1) {
                reducedKnots.add(knotList.toArray((Object[])Array.newInstance(clazz, knotList.size())));
            }
            ++n2;
        }
        Class<?> arrayClass = Array.newInstance(clazz, 0).getClass();
        return new VertexOrder<Object>(reducedVertexes, reducedKnots.size() > 0, (Object[][])reducedKnots.toArray((T[])((Object[][])Array.newInstance(arrayClass, reducedKnots.size()))));
    }

    public static <T> Digraph<T> computeGraph(Collection<T> vertexes, Collection<T[]> references, Class<T> clazz) {
        Digraph<Object> g1 = new Digraph<Object>(clazz);
        for (T t : vertexes) {
            g1.addVertex(t);
        }
        for (Object[] objectArray : references) {
            if (objectArray.length != 2) {
                throw new IllegalArgumentException();
            }
            Object p = objectArray[0];
            Object q = objectArray[1];
            if (p == null || q == null) {
                throw new IllegalArgumentException();
            }
            g1.addEdge(q, p);
        }
        g1.freeze();
        return g1;
    }

    public static <T> Digraph<T> buildFilteredDigraph(Digraph<T> initialGraph, Predicate<T> filterOut, Class<T> clazz) {
        Digraph res = new Digraph(clazz);
        LinkedHashSet toRemove = new LinkedHashSet();
        for (Digraph.Vertex vertex : initialGraph.vertexList) {
            Object id = vertex.id;
            if (!filterOut.test(id)) {
                res.addVertex(id);
                continue;
            }
            toRemove.add(id);
        }
        if (res.vertexList.size() < 2) {
            return res;
        }
        LinkedHashSet edgesWithRemovedRef = new LinkedHashSet();
        initialGraph.getEdges().forEach(edge -> {
            if (toRemove.contains(edge.from) || toRemove.contains(edge.to)) {
                edgesWithRemovedRef.add(edge);
            } else {
                res.addEdge(edge.from, edge.to);
            }
        });
        for (Object idToRemove : toRemove) {
            LinkedHashSet<Digraph.Edge> incoming = new LinkedHashSet<Digraph.Edge>();
            LinkedHashSet<Digraph.Edge> outgoing = new LinkedHashSet<Digraph.Edge>();
            for (Digraph.Edge edge2 : edgesWithRemovedRef) {
                if (edge2.from == idToRemove) {
                    outgoing.add(edge2);
                    continue;
                }
                if (edge2.to != idToRemove) continue;
                incoming.add(edge2);
            }
            edgesWithRemovedRef.removeAll(incoming);
            edgesWithRemovedRef.removeAll(outgoing);
            incoming.forEach(incomingEdge -> outgoing.forEach(outgoingEdge -> {
                Digraph.Edge edge2 = new Digraph.Edge(edge.from, outgoingEdge.to);
                if (toRemove.contains(edge2.from) || toRemove.contains(edge2.to)) {
                    edgesWithRemovedRef.add(edge2);
                } else {
                    res.addEdge(edge2.from, edge2.to);
                }
            }));
        }
        if (!edgesWithRemovedRef.isEmpty()) {
            throw new IllegalStateException("There should be no remaining edge at this point.");
        }
        return res;
    }

    public static class Digraph<T> {
        public final List<Vertex<T>> vertexList = new ArrayList<Vertex<T>>(100);
        public final Map<T, Vertex<T>> vertexMap = new LinkedHashMap<T, Vertex<T>>(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;
        private Class<T> clazz;

        public Digraph(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(T id) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex<T> vertex = new Vertex<T>(id);
            Vertex<T> existing = this.vertexMap.put(id, vertex);
            if (existing != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(T fromId, T toId) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex<T> fromVertex = this.vertexMap.get(fromId);
            Vertex<T> toVertex = this.vertexMap.get(toId);
            if (fromVertex == null) {
                throw new IllegalArgumentException();
            }
            if (toVertex == null) {
                throw new IllegalArgumentException();
            }
            fromVertex.adjacent.add(toVertex);
        }

        public List<T> idsByDFSFinishTime(boolean increasing) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int len = this.vertexList.size();
            Object[] r = (Object[])Array.newInstance(this.clazz, len);
            for (Vertex<T> vertex : this.vertexList) {
                int f = vertex.finishTime;
                if (increasing) {
                    r[f - 1] = vertex.id;
                    continue;
                }
                r[len - f] = vertex.id;
            }
            return Arrays.asList(r);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List<T[]> nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            LinkedHashMap components = new LinkedHashMap();
            for (Vertex<T> vertex : this.vertexList) {
                if (vertex.predecessor == null) continue;
                Vertex<T> root = vertex;
                while (root.predecessor != null) {
                    root = root.predecessor;
                }
                ArrayList component = (ArrayList)components.get(root);
                if (component == null) {
                    component = new ArrayList(2);
                    component.add(root.id);
                    components.put(root, component);
                }
                component.add(vertex.id);
            }
            ArrayList<T[]> result = new ArrayList<T[]>(components.size());
            for (List component : components.values()) {
                if (component.size() <= 1) continue;
                result.add(component.toArray((Object[])Array.newInstance(this.clazz, component.size())));
            }
            return result;
        }

        private void DFS() {
            Integer NEXT_VERTEX_OBJECT = 1;
            Integer AFTER_NEXTED_DFS_VISIT_OBJECT = 4;
            this.time = 0;
            ArrayList<Object> stack = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Iterator allAdjacent = null;
            Vertex vertex = null;
            Iterator<Vertex<T>> allV = this.vertexList.iterator();
            int state = 1;
            block6: while (true) {
                switch (state) {
                    case 1: {
                        if (!allV.hasNext()) break block6;
                        Vertex nextVertex = allV.next();
                        if (nextVertex.color == "white") {
                            stack.add(NEXT_VERTEX_OBJECT);
                            vertex = nextVertex;
                            state = 2;
                            continue block6;
                        }
                        state = 1;
                        continue block6;
                    }
                    case 2: {
                        vertex.color = "grey";
                        allAdjacent = vertex.adjacent.iterator();
                        state = 3;
                        continue block6;
                    }
                    case 3: {
                        if (allAdjacent.hasNext()) {
                            Vertex adjVertex = (Vertex)allAdjacent.next();
                            if (adjVertex.color == "white") {
                                adjVertex.predecessor = vertex;
                                stack.add(allAdjacent);
                                stack.add(vertex);
                                stack.add(AFTER_NEXTED_DFS_VISIT_OBJECT);
                                vertex = adjVertex;
                                state = 2;
                                continue block6;
                            }
                            if (adjVertex.color == "grey") {
                                this.cycles = true;
                            }
                            state = 3;
                            continue block6;
                        }
                        vertex.color = "black";
                        vertex.finishTime = ++this.time;
                        state = (Integer)stack.remove(stack.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        vertex = (Vertex)stack.remove(stack.size() - 1);
                        allAdjacent = (Iterator)stack.remove(stack.size() - 1);
                        state = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public Collection<Edge<T>> getEdges() {
            int size = 0;
            for (Vertex<T> vertex2 : this.vertexList) {
                size += vertex2.adjacent.size();
            }
            LinkedHashSet res = new LinkedHashSet(size, 1.0f);
            this.vertexList.forEach(vertex -> vertex.adjacent.forEach(adjacent -> {
                boolean bl = res.add(new Edge(vertex.id, adjacent.id));
            }));
            return res;
        }

        public static class Edge<T> {
            public final T from;
            public final T to;

            public Edge(T from, T to) {
                this.from = from;
                this.to = to;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Edge)) {
                    return false;
                }
                Edge other = (Edge)obj;
                return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
            }

            public int hashCode() {
                return Objects.hash(this.from, this.to);
            }
        }

        public static class Vertex<T> {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex<T> predecessor = null;
            public int finishTime;
            public T id;
            public List<Vertex<T>> adjacent = new ArrayList<Vertex<T>>(3);

            public Vertex(T id) {
                this.id = id;
            }
        }
    }

    public static class VertexOrder<T> {
        public T[] vertexes;
        public boolean hasCycles;
        public T[][] knots;

        public VertexOrder(T[] vertexes, boolean hasCycles, T[][] knots) {
            this.vertexes = vertexes;
            this.hasCycles = hasCycles;
            this.knots = knots;
        }
    }
}

