/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.modulepar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ModuleParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigItemTransferBase;

public final class ModuleParameterTransfer
extends ConfigItemTransferBase {
    private static ModuleParameterTransfer instance = new ModuleParameterTransfer();
    private static final String TYPE_NAME = "TITAN-ModuleParameter-transfer-format";
    private static final int TYPEID = ModuleParameterTransfer.registerType((String)"TITAN-ModuleParameter-transfer-format");

    public static ModuleParameterTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ModuleParameterSectionHandler.ModuleParameter[] items = (ModuleParameterSectionHandler.ModuleParameter[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                out.writeUTF(this.convertToString(items[i].getRoot()));
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected ModuleParameterSectionHandler.ModuleParameter[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            ModuleParameterSectionHandler.ModuleParameter[] items = new ModuleParameterSectionHandler.ModuleParameter[n];
            for (int i = 0; i < n; ++i) {
                ModuleParameterSectionHandler.ModuleParameter newModuleParameter = new ModuleParameterSectionHandler.ModuleParameter();
                ParserRuleContext root = new ParserRuleContext();
                newModuleParameter.setRoot((ParseTree)root);
                String hiddenBeforeModuleName = in.readUTF();
                String moduleName = in.readUTF();
                String hiddenBeforeSeparator = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("\n"));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(hiddenBeforeModuleName));
                newModuleParameter.setModuleName((ParseTree)new AddedParseTree(moduleName));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(hiddenBeforeSeparator));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getModuleName());
                boolean isModuleNameEmpty = moduleName == null || moduleName.isEmpty();
                newModuleParameter.setSeparator((ParseTree)new AddedParseTree(isModuleNameEmpty ? "" : "."));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getSeparator());
                String hiddenBeforeParameterName = in.readUTF();
                String parameterName = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(hiddenBeforeParameterName));
                newModuleParameter.setParameterName((ParseTree)new AddedParseTree(parameterName));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getParameterName());
                String hiddenBeforeOperator = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(hiddenBeforeOperator));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
                String hiddenBeforeValue = in.readUTF();
                String value = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(hiddenBeforeValue));
                newModuleParameter.setValue((ParseTree)new AddedParseTree(value));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newModuleParameter.getValue());
                items[i] = newModuleParameter;
            }
            return items;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ModuleParameterSectionHandler.ModuleParameter[0];
        }
    }
}

