/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsViaReferences;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionMethodBase;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class BrokenPartsChecker {
    private final SubMonitor progress;
    private final IProgressMonitor monitor;
    private final CompilationTimeStamp compilationCounter;
    private final SelectionMethodBase selectionMethod;

    public BrokenPartsChecker(SubMonitor monitor, CompilationTimeStamp compilationCounter, SelectionMethodBase selectionMethod) {
        this.compilationCounter = compilationCounter;
        this.selectionMethod = selectionMethod;
        this.monitor = monitor;
        this.progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
    }

    public void doChecking() {
        this.monitor.subTask("Semantic checking");
        switch (this.selectionMethod.getSelectionAlgorithm()) {
            case MODULESELECTIONORIGINAL: {
                this.generalChecker();
                break;
            }
            case BROKENREFERENCESINVERTED: {
                BrokenPartsViaReferences brokenParts = (BrokenPartsViaReferences)this.selectionMethod;
                if (brokenParts.getAnalyzeOnlyDefinitions()) {
                    Map<Module, List<Assignment>> moduleAndBrokenDefinitions = brokenParts.getModuleAndBrokenDefs();
                    this.definitionsChecker(moduleAndBrokenDefinitions);
                    break;
                }
                this.generalChecker();
                break;
            }
            default: {
                this.generalChecker();
            }
        }
        this.monitor.subTask("Doing post semantic checks");
        for (Module module : this.selectionMethod.getModulesToCheck()) {
            module.postCheck();
        }
        this.progress.done();
    }

    private void generalChecker() {
        this.progress.setTaskName("Semantic check");
        this.progress.setWorkRemaining(this.selectionMethod.getModulesToCheck().size());
        for (Module module : this.selectionMethod.getModulesToSkip()) {
            module.setSkippedFromSemanticChecking(true);
        }
        for (Module module : this.selectionMethod.getModulesToCheck()) {
            module.setSkippedFromSemanticChecking(false);
        }
        for (Module module : this.selectionMethod.getModulesToCheck()) {
            this.progress.subTask("Semantically checking module: " + module.getName());
            module.check(this.compilationCounter);
            this.progress.worked(1);
        }
        for (Module module : this.selectionMethod.getModulesToSkip()) {
            module.setSkippedFromSemanticChecking(false);
        }
    }

    private void definitionsChecker(Map<Module, List<Assignment>> moduleAndBrokenDefs) {
        this.progress.setTaskName("Semantic check");
        this.progress.setWorkRemaining(moduleAndBrokenDefs.size());
        for (Map.Entry<Module, List<Assignment>> entry : moduleAndBrokenDefs.entrySet()) {
            Module module = entry.getKey();
            this.progress.subTask("Semantically checking broken parts in module: " + module.getName());
            if (module instanceof TTCN3Module) {
                ((TTCN3Module)module).checkWithDefinitions(this.compilationCounter, entry.getValue());
            } else {
                module.check(this.compilationCounter);
            }
            this.progress.worked(1);
        }
    }
}

