/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.services.IDisposable;

public class SlaveSelectionService
implements ISelectionService,
IDisposable {
    private ListenerList<ISelectionListener> postListeners = new ListenerList(1);
    private ListenerList<ISelectionListener> listeners = new ListenerList(1);
    private Map<ISelectionListener, String> listenersToPartId = new HashMap<ISelectionListener, String>();
    private Map<ISelectionListener, String> postListenersToPartId = new HashMap<ISelectionListener, String>();
    private ISelectionService parentSelectionService;

    public SlaveSelectionService(ISelectionService parentSelectionService) {
        if (parentSelectionService == null) {
            throw new IllegalArgumentException("The parent selection service cannot be null");
        }
        this.parentSelectionService = parentSelectionService;
    }

    @Override
    public void addPostSelectionListener(ISelectionListener listener) {
        this.postListeners.add((Object)listener);
        this.parentSelectionService.addPostSelectionListener(listener);
    }

    @Override
    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        this.listenersToPartId.put(listener, partId);
        this.parentSelectionService.addPostSelectionListener(partId, listener);
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add((Object)listener);
        this.parentSelectionService.addSelectionListener(listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        this.postListenersToPartId.put(listener, partId);
        this.parentSelectionService.addPostSelectionListener(partId, listener);
    }

    @Override
    public ISelection getSelection() {
        return this.parentSelectionService.getSelection();
    }

    @Override
    public ISelection getSelection(String partId) {
        return this.parentSelectionService.getSelection(partId);
    }

    @Override
    public void removePostSelectionListener(ISelectionListener listener) {
        this.postListeners.remove((Object)listener);
        this.parentSelectionService.removePostSelectionListener(listener);
    }

    @Override
    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        this.postListenersToPartId.remove(listener);
        this.parentSelectionService.removePostSelectionListener(partId, listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove((Object)listener);
        this.parentSelectionService.removeSelectionListener(listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        this.listenersToPartId.remove(listener);
        this.parentSelectionService.removeSelectionListener(partId, listener);
    }

    @Override
    public void dispose() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            this.parentSelectionService.removeSelectionListener((ISelectionListener)list[i]);
            ++i;
        }
        this.listeners.clear();
        list = this.postListeners.getListeners();
        i = 0;
        while (i < list.length) {
            this.parentSelectionService.removePostSelectionListener((ISelectionListener)list[i]);
            ++i;
        }
        this.postListeners.clear();
        for (Map.Entry<ISelectionListener, String> entry : this.listenersToPartId.entrySet()) {
            this.parentSelectionService.removeSelectionListener(entry.getValue(), entry.getKey());
        }
        this.listenersToPartId.clear();
        for (Map.Entry<ISelectionListener, String> entry : this.postListenersToPartId.entrySet()) {
            this.parentSelectionService.removePostSelectionListener(entry.getValue(), entry.getKey());
        }
        this.postListenersToPartId.clear();
    }
}

