/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.view;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.msc.ui.view.Overview;

public class ScrollView
extends Composite {
    public static final int AUTO = 0;
    public static final int ALWAYS_OFF = 2;
    public static final int ALWAYS_ON = 1;
    private boolean autoScrollEnabled = true;
    private int autoScrollPeriod = 75;
    private int hScrollbarMode = 0;
    private int vScrollbarMode = 0;
    private int hScrollbarIncrement = 10;
    private int vScrollbarIncrement = 10;
    protected int contentsHeight = 0;
    protected int contentsWidth = 0;
    protected int contentsX = 0;
    protected int contentsY = 0;
    private Canvas vertsb;
    private Canvas horzsb = new Canvas((Composite)this, 0x20000100);
    protected Canvas viewcontrol;
    protected Control cornerControl;
    protected Overview overview;
    private AutoScroll autoScroll = null;
    private Timer autoScrollTimer = null;
    private int mouseDownX = -1;
    private int mouseDownY = -1;
    public static final int VBAR = 1;
    public static final int HBAR = 2;

    public ScrollView(Composite c, int style, boolean mouseWheel) {
        super(c, 0);
        this.viewcontrol = mouseWheel ? new Canvas((Composite)this, style | 0x100 | 0x200 | 0x40000 | 0x20000000) : new Canvas((Composite)this, style | 0x40000 | 0x20000000);
        this.viewcontrol.setBackground(this.getBackground());
        if (mouseWheel) {
            this.viewcontrol.getVerticalBar().setVisible(false);
            this.viewcontrol.getHorizontalBar().setVisible(false);
        }
        this.vertsb = new Canvas((Composite)this, 0x20000200);
        this.setLayout(new SVLayout());
        Button b = new Button((Composite)this, 0);
        b.setImage(Activator.getDefault().getIcon("icons/overview.gif"));
        this.overview = new Overview(this);
        this.overview.useControl((Control)b);
        b.setData((Object)this.overview);
        Button cc = b;
        b.setToolTipText(Messages.getString("ScrollView.0"));
        this.setCornerControl((Control)cc);
        this.initListerners();
    }

    private void initListerners() {
        PaintListener localPaintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle r = event.gc.getClipping();
                int cx = ScrollView.this.viewToContentsX(r.x);
                int cy = ScrollView.this.viewToContentsY(r.y);
                ScrollView.this.drawContents(event.gc, cx, cy, r.width, r.height);
            }
        };
        this.viewcontrol.addPaintListener(localPaintListener);
        MouseMoveListener localMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseMoveEvent(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.viewcontrol.addMouseMoveListener(localMouseMoveListener);
        this.viewcontrol.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.verticalScrollBarEvent(e);
            }
        });
        MouseTrackListener localMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseEnter(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseHover(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseHover(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseExit(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseExit(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.viewcontrol.addMouseTrackListener(localMouseTrackListener);
        MouseListener localMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseDoubleClickEvent(e);
                e.x = ox;
                e.y = oy;
                Event event = new Event();
                ScrollView.this.notifyListeners(8, event);
            }

            public void mouseDown(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                ScrollView.this.mouseDownX = ScrollView.this.viewToContentsX(e.x);
                e.x = ScrollView.this.mouseDownX;
                ScrollView.this.mouseDownY = ScrollView.this.viewToContentsY(e.y);
                e.y = ScrollView.this.mouseDownY;
                ScrollView.this.contentsMouseDownEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseUp(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseUpEvent(e);
                e.x = ox;
                e.y = oy;
                ScrollView.this.mouseDownY = -1;
                ScrollView.this.mouseDownX = -1;
            }
        };
        this.viewcontrol.addMouseListener(localMouseListener);
        KeyListener localKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ScrollView.this.keyPressedEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                ScrollView.this.keyReleasedEvent(e);
            }
        };
        this.viewcontrol.addKeyListener(localKeyListener);
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.contentsX, ScrollView.this.getVerticalBar().getSelection());
                if (!ScrollView.this.viewcontrol.isFocusControl()) {
                    ScrollView.this.viewcontrol.setFocus();
                }
            }
        });
        if (this.viewcontrol.getVerticalBar() != null) {
            this.viewcontrol.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.viewcontrol.getVerticalBar();
                    ScrollView.this.setContentsPos(ScrollView.this.contentsX, b.getSelection());
                    ScrollView.this.getVerticalBar().setSelection(b.getSelection());
                }
            });
        }
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.getHorizontalBar().getSelection(), ScrollView.this.contentsY);
                if (!ScrollView.this.viewcontrol.isFocusControl()) {
                    ScrollView.this.viewcontrol.setFocus();
                }
            }
        });
        if (this.viewcontrol.getHorizontalBar() != null) {
            this.viewcontrol.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.viewcontrol.getHorizontalBar();
                    ScrollView.this.setContentsPos(b.getSelection(), ScrollView.this.contentsY);
                    ScrollView.this.getHorizontalBar().setSelection(b.getSelection());
                }
            });
        }
    }

    protected void verticalScrollBarEvent(SelectionEvent e) {
    }

    public boolean setFocus() {
        return this.viewcontrol != null && !this.viewcontrol.isDisposed() && this.viewcontrol.forceFocus();
    }

    public void setCursor(Cursor cursor) {
        if (this.viewcontrol != null) {
            this.viewcontrol.setCursor(cursor);
        }
    }

    public void dispose() {
        if (this.autoScroll != null) {
            this.autoScroll.cancel();
            this.autoScroll = null;
        }
        if (this.viewcontrol != null) {
            this.viewcontrol.dispose();
        }
        this.viewcontrol = null;
        if (this.vertsb != null) {
            this.vertsb.dispose();
        }
        this.vertsb = null;
        if (this.horzsb != null) {
            this.horzsb.dispose();
        }
        this.horzsb = null;
        if (this.cornerControl != null) {
            Object data = this.cornerControl.getData();
            if (data instanceof Overview) {
                ((Overview)data).dispose();
            }
            this.cornerControl.dispose();
            this.cornerControl = null;
        }
        super.dispose();
    }

    public Rectangle getClientArea() {
        return this.viewcontrol.getClientArea();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.viewcontrol.setBackground(c);
    }

    public void setToolTipText(String text) {
        this.viewcontrol.setToolTipText(text);
    }

    protected void drawOverview(GC gc, Rectangle r) {
        int x = (int)((float)(r.width * this.contentsX) / (float)this.contentsWidth);
        int y = (int)((float)(r.height * this.contentsY) / (float)this.contentsHeight);
        int vw = this.getVisibleWidth();
        int vh = this.getVisibleHeight();
        int w = r.width - 1;
        if (this.contentsWidth > vw) {
            w = (int)((float)(r.width * vw) / (float)this.contentsWidth);
        }
        int h = r.height - 1;
        if (this.contentsHeight > vh) {
            h = (int)((float)(r.height * vh) / (float)this.contentsHeight);
        }
        gc.setForeground(this.getForeground());
        if (w < 5 || h < 5) {
            gc.drawLine(x, 0, x, r.height);
            gc.drawLine(0, y, r.width, y);
        } else {
            gc.drawRectangle(x, y, w, h);
        }
    }

    public int getContentsHeight() {
        return this.contentsHeight;
    }

    public int getContentsWidth() {
        return this.contentsWidth;
    }

    public int getContentsX() {
        return this.contentsX;
    }

    public int getContentsY() {
        return this.contentsY;
    }

    public boolean getDragAutoScroll() {
        return this.autoScrollEnabled;
    }

    public void setDragAutoScroll(boolean aDragAutoScroll) {
        this.autoScrollEnabled = aDragAutoScroll;
        if (!this.autoScrollEnabled && this.autoScroll != null) {
            this.autoScroll.cancel();
            this.autoScroll = null;
        }
    }

    public void setDragAutoScrollPeriod(int period) {
        this.autoScrollPeriod = Math.max(0, period);
    }

    public int getDragAutoScrollPeriod() {
        return this.autoScrollPeriod;
    }

    public int getHScrollBarMode() {
        return this.hScrollbarMode;
    }

    public void setHScrollBarMode(int aHScrollBarMode) {
        this.hScrollbarMode = aHScrollBarMode;
    }

    public int getVScrollBarMode() {
        return this.vScrollbarMode;
    }

    public void setVScrollBarMode(int aVScrollBarMode) {
        this.vScrollbarMode = aVScrollBarMode;
    }

    public int getHScrollBarIncrement() {
        return this.hScrollbarIncrement;
    }

    public int getVScrollBarIncrement() {
        return this.vScrollbarIncrement;
    }

    public void setHScrollBarIncrement(int inc) {
        this.hScrollbarIncrement = Math.max(1, inc);
    }

    public void setVScrollBarIncrement(int inc) {
        this.vScrollbarIncrement = Math.max(1, inc);
    }

    public Control getViewControl() {
        return this.viewcontrol;
    }

    protected void contentsMouseExit(MouseEvent e) {
    }

    protected void contentsMouseHover(MouseEvent e) {
    }

    protected void contentsMouseEnter(MouseEvent e) {
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent e) {
    }

    protected void contentsMouseDownEvent(MouseEvent e) {
        this.mouseDownX = e.x;
        this.mouseDownY = e.y;
    }

    protected void contentsMouseMoveEvent(MouseEvent event) {
        if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
            if (!this.autoScrollEnabled) {
                this.scrollBy(-(event.x - this.mouseDownX), -(event.y - this.mouseDownY));
                return;
            }
            int sx = 0;
            int sy = 0;
            int vRight = this.getContentsX() + this.getVisibleWidth();
            int vBottom = this.getContentsY() + this.getVisibleHeight();
            if (event.x < this.getContentsX()) {
                sx = this.getContentsX() - event.x;
                this.mouseDownX = this.getContentsX();
            } else if (event.x > vRight) {
                sx = -event.x + vRight;
                this.mouseDownX = vRight;
            }
            if (event.y < this.getContentsY()) {
                sy = this.getContentsY() - event.y;
                this.mouseDownY = this.getContentsY();
            } else if (event.y > vBottom) {
                sy = -event.y + vBottom;
                this.mouseDownY = vBottom;
            }
            if (sx != 0 || sy != 0) {
                if (this.autoScroll == null) {
                    if (this.autoScrollTimer == null) {
                        this.autoScrollTimer = new Timer(true);
                    }
                    this.autoScroll = new AutoScroll(this, sx, sy);
                    this.autoScrollTimer.schedule((TimerTask)this.autoScroll, 0L, (long)this.autoScrollPeriod);
                } else {
                    this.autoScroll.dx = sx;
                    this.autoScroll.dy = sy;
                }
            } else {
                if (this.autoScroll != null) {
                    this.autoScroll.cancel();
                    this.autoScroll = null;
                }
                this.scrollBy(-(event.x - this.mouseDownX), -(event.y - this.mouseDownY));
            }
        }
    }

    protected void contentsMouseUpEvent(MouseEvent event) {
        if (this.autoScroll != null) {
            this.autoScroll.cancel();
            this.autoScroll = null;
        }
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
    }

    public void resizeContents(int w, int h) {
        int tempW = w;
        int tempH = h;
        if (w < 0) {
            tempW = 0;
        }
        if (h < 0) {
            tempH = 0;
        }
        int oldW = this.contentsWidth;
        int oldH = this.contentsHeight;
        if (tempW == oldW && tempH == oldH) {
            return;
        }
        this.contentsWidth = tempW;
        this.contentsHeight = tempH;
        if (oldW > tempW) {
            int s = tempW;
            tempW = oldW;
            oldW = s;
        }
        int visWidth = this.getVisibleWidth();
        int visHeight = this.getVisibleHeight();
        if (oldW < visWidth) {
            if (tempW > visWidth) {
                tempW = visWidth;
            }
            this.viewcontrol.redraw(this.getContentsX() + oldW, 0, tempW - oldW, visHeight, true);
        }
        if (oldH > tempH) {
            int s = tempH;
            tempH = oldH;
            oldH = s;
        }
        if (oldH < visHeight) {
            if (tempH > visHeight) {
                tempH = visHeight;
            }
            this.viewcontrol.redraw(0, this.getContentsY() + oldH, visWidth, tempH - oldH, true);
        }
        if (this.updateScrollBarVisiblity()) {
            this.layout();
        } else {
            this.updateScrollBarsValues();
        }
    }

    public void redraw() {
        if (this.isDisposed()) {
            return;
        }
        super.redraw();
        this.viewcontrol.redraw();
    }

    public void scrollBy(int dx, int dy) {
        this.setContentsPos(this.getContentsX() + dx, this.getContentsY() + dy);
    }

    public void ensureVisible(int px, int py) {
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth();
        int bottom = this.getContentsY() + this.getVisibleHeight();
        if (px < this.getContentsX()) {
            cx = px;
        } else if (px > right) {
            cx = px - this.getVisibleWidth();
        }
        if (py < this.getContentsY()) {
            cy = py;
        } else if (py > bottom) {
            cy = py - this.getVisibleHeight();
        }
        this.setContentsPos(cx, cy);
    }

    public void ensureVisible(int x, int y, int w, int h, int align) {
        this.ensureVisible(x, y, w, h, align, false);
    }

    protected void ensureVisible(int x, int y, int w, int h, int align, boolean forceAlign) {
        int tempX = x;
        int tempY = y;
        int tempW = w;
        int tempH = h;
        if (w < 0) {
            tempX += w;
            tempW = -w;
        }
        if (h < 0) {
            tempY += h;
            tempH = -h;
        }
        int hbar = this.getHorizontalBarHeight();
        int vbar = this.getVerticalBarWidth();
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth() - vbar;
        int bottom = this.getContentsY() + this.getVisibleHeight() - hbar;
        boolean alignH = false;
        boolean alignV = false;
        if (tempX < this.getContentsX()) {
            cx = tempX;
        } else if (tempX + tempW > right) {
            cx = tempX - tempW;
        }
        if (tempY < this.getContentsY()) {
            cy = tempY;
        } else if (tempY + tempH > bottom) {
            cy = tempY - tempH;
        }
        if (tempW > this.getVisibleWidth()) {
            alignH = true;
        }
        if (tempH > this.getVisibleHeight()) {
            alignV = true;
        }
        if (alignH || forceAlign && tempX + tempW > right) {
            cx = (align & 0x4000) != 0 ? tempX : ((align & 0x20000) != 0 ? right - tempW : tempX + (tempW - this.getVisibleWidth()) / 2);
        }
        if (alignV || forceAlign && tempY + tempH > bottom) {
            cy = (align & 0x80) != 0 ? tempY : ((align & 0x400) != 0 ? bottom - tempH : tempY + (tempH - this.getVisibleHeight()) / 2);
        }
        this.setContentsPos(cx, cy);
    }

    public boolean isVisible(int px, int py) {
        if (px < this.getContentsX()) {
            return false;
        }
        if (py < this.getContentsY()) {
            return false;
        }
        if (px > this.getContentsX() + this.getVisibleWidth()) {
            return false;
        }
        return py <= this.getContentsY() + this.getVisibleHeight();
    }

    public boolean isVisible(int x, int y, int w, int h) {
        if (x + w < this.getContentsX()) {
            return false;
        }
        if (y + h < this.getContentsY()) {
            return false;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (x > vr) {
            return false;
        }
        return y <= vb;
    }

    public Rectangle getVisiblePart(int x, int y, int w, int h) {
        if (x + w < this.getContentsX()) {
            return null;
        }
        if (y + h < this.getContentsY()) {
            return null;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (x > vr) {
            return null;
        }
        if (y > vb) {
            return null;
        }
        int rr = x + w;
        int rb = y + h;
        int nl = Math.max(x, this.getContentsX());
        int nt = Math.max(y, this.getContentsY());
        int nr = Math.min(rr, vr);
        int nb = Math.min(rb, vb);
        return new Rectangle(nl, nt, nr - nl, nb - nt);
    }

    public final Rectangle getVisiblePart(Rectangle r) {
        if (r == null) {
            return null;
        }
        return this.getVisiblePart(r.x, r.y, r.width, r.height);
    }

    public boolean setContentsPos(int x, int y) {
        int nx = x;
        int ny = y;
        if (this.getVisibleWidth() >= this.getContentsWidth()) {
            nx = 0;
        } else if (x < 0) {
            nx = 0;
        } else if (x + this.getVisibleWidth() > this.getContentsWidth()) {
            nx = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (this.getVisibleHeight() >= this.getContentsHeight()) {
            ny = 0;
        } else if (y <= 0) {
            ny = 0;
        } else if (y + this.getVisibleHeight() > this.getContentsHeight()) {
            ny = this.getContentsHeight() - this.getVisibleHeight();
        }
        if (nx == this.contentsX && ny == this.contentsY) {
            return false;
        }
        this.contentsX = nx;
        this.contentsY = ny;
        this.updateScrollBarsValues();
        this.viewcontrol.redraw();
        return true;
    }

    public ScrollBar getVerticalBar() {
        return this.vertsb.getVerticalBar();
    }

    public ScrollBar getHorizontalBar() {
        return this.horzsb.getHorizontalBar();
    }

    public int computeBarVisibility(int forWidth, int forHeight, boolean currHVis, boolean currVVis) {
        int vis = 0;
        switch (this.vScrollbarMode) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 1;
                break;
            }
            case 0: {
                if (this.getContentsHeight() <= forHeight) break;
                vis = 1;
                if (currVVis) break;
                break;
            }
        }
        switch (this.hScrollbarMode) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 2;
                break;
            }
            case 0: {
                if (this.getContentsWidth() <= forWidth) break;
                vis |= 2;
                if (currHVis || this.getContentsHeight() <= forHeight - this.getHorizontalBarHeight()) break;
                vis |= 1;
                break;
            }
        }
        return vis;
    }

    private boolean updateScrollBarVisiblity() {
        boolean newHVis;
        boolean change = false;
        boolean currVVis = this.vertsb.getVisible();
        boolean currHVis = this.horzsb.getVisible();
        int barNewVis = this.computeBarVisibility(this.getVisibleWidth(), this.getVisibleHeight(), currHVis, currVVis);
        boolean newVVis = (barNewVis & 1) != 0;
        boolean bl = newHVis = (barNewVis & 2) != 0;
        if (currVVis ^ newVVis) {
            this.vertsb.setVisible(newVVis);
            change = true;
        }
        if (currHVis ^ newHVis) {
            this.horzsb.setVisible(newHVis);
            change = true;
        }
        if (this.cornerControl != null && change) {
            boolean vis;
            boolean bl2 = vis = newVVis || newHVis;
            if (vis ^ this.cornerControl.getVisible()) {
                this.cornerControl.setVisible(vis);
                change = true;
            }
        }
        return change;
    }

    private void updateScrollBarsValues() {
        ScrollBar b = this.getVerticalBar();
        if (b != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.vScrollbarIncrement);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.viewcontrol.getVerticalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.vScrollbarIncrement);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.hScrollbarIncrement);
        }
        if ((b = this.viewcontrol.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.hScrollbarIncrement);
        }
    }

    public void setCornerControl(Control w) {
        if (this.cornerControl != null) {
            this.cornerControl.dispose();
        }
        this.cornerControl = w;
        if (this.cornerControl != null) {
            ScrollBar vb = this.getVerticalBar();
            ScrollBar hb = this.getHorizontalBar();
            boolean vis = vb.getVisible() || hb.getVisible();
            this.cornerControl.setVisible(vis);
        }
    }

    public final Point viewToContents(int x, int y) {
        return new Point(this.viewToContentsX(x), this.viewToContentsY(y));
    }

    public int viewToContentsX(int x) {
        return this.contentsX + x;
    }

    public int viewToContentsY(int y) {
        return this.contentsY + y;
    }

    public final Point contentsToView(int x, int y) {
        return new Point(this.contentsToViewX(x), this.contentsToViewY(y));
    }

    public int contentsToViewX(int x) {
        return x - this.contentsX;
    }

    public int contentsToViewY(int y) {
        return y - this.contentsY;
    }

    public int getVisibleHeight() {
        Rectangle r = this.viewcontrol.getClientArea();
        return r.height;
    }

    public int getVisibleWidth() {
        Rectangle r = this.viewcontrol.getClientArea();
        return r.width;
    }

    protected void keyPressedEvent(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000001: {
                this.upArrowPressed();
                break;
            }
            case 0x1000002: {
                this.downArrowPressed();
                break;
            }
            case 0x1000005: {
                this.scrollBy(0, -this.getVisibleHeight());
                break;
            }
            case 0x1000006: {
                this.scrollBy(0, this.getVisibleHeight());
                break;
            }
            case 0x1000003: {
                this.scrollBy(-this.getVisibleWidth() / 4, 0);
                break;
            }
            case 0x1000004: {
                this.scrollBy(this.getVisibleWidth() / 4, 0);
                break;
            }
            case 13: {
                Event event = new Event();
                event.keyCode = 13;
                this.notifyListeners(1, event);
                break;
            }
        }
    }

    protected void keyReleasedEvent(KeyEvent e) {
    }

    protected void viewResized() {
    }

    public int getVerticalBarWidth() {
        int bw = this.vertsb.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        return bw + 1;
    }

    public int getHorizontalBarHeight() {
        int bh = this.horzsb.computeTrim((int)0, (int)0, (int)0, (int)0).height;
        return bh + 1;
    }

    public Rectangle computeTrim(int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        int barVis = this.computeBarVisibility(w, h, false, false);
        if ((barVis & 1) != 0) {
            r.width += this.getVerticalBarWidth();
        }
        if ((barVis & 2) != 0) {
            r.height += this.getHorizontalBarHeight();
        }
        return r;
    }

    protected void upArrowPressed() {
    }

    protected void downArrowPressed() {
    }

    private class SVLayout
    extends Layout {
        private int seek = 0;
        private boolean dontLayout = false;

        private SVLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point p = new Point(250, 250);
            if (ScrollView.this.contentsWidth < p.x) {
                p.x = ScrollView.this.contentsWidth;
            }
            if (ScrollView.this.contentsHeight < p.y) {
                p.y = ScrollView.this.contentsHeight;
            }
            return p;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (this.dontLayout) {
                return;
            }
            ++this.seek;
            if (this.seek > 10) {
                this.dontLayout = true;
            }
            Point cs = composite.getSize();
            int barVisibility = ScrollView.this.computeBarVisibility(cs.x, cs.y, false, false);
            boolean vbVis = (barVisibility & 1) != 0;
            boolean hbVis = (barVisibility & 2) != 0;
            ScrollView.this.vertsb.setVisible(vbVis);
            ScrollView.this.horzsb.setVisible(hbVis);
            int vbw = ScrollView.this.getVerticalBarWidth();
            int hbh = ScrollView.this.getHorizontalBarHeight();
            int wb = vbVis ? vbw : 0;
            int hb = hbVis ? hbh : 0;
            int cww = 0;
            int cwh = 0;
            if (ScrollView.this.cornerControl != null && (vbVis || hbVis)) {
                ScrollView.this.cornerControl.setVisible(true);
                cww = vbw;
                cwh = hbh;
                if (wb == 0) {
                    wb = vbw;
                }
                if (hb == 0) {
                    hb = hbh;
                }
            } else if (vbVis && hbVis) {
                if (ScrollView.this.cornerControl != null) {
                    ScrollView.this.cornerControl.setVisible(false);
                }
                cww = vbw;
                cwh = hbh;
            }
            if (vbVis || hbVis) {
                ScrollView.this.updateScrollBarsValues();
            }
            int vw = cs.x - (vbVis ? vbw : 0);
            int vh = cs.y - (hbVis ? hbh : 0);
            int vbx = cs.x - wb;
            int hby = cs.y - hb;
            Rectangle rc = ScrollView.this.viewcontrol.getClientArea();
            int oldWidth = rc.width;
            int oldHeight = rc.height;
            ScrollView.this.viewcontrol.setBounds(0, 0, vw, vh);
            boolean doViewResize = false;
            rc = ScrollView.this.viewcontrol.getClientArea();
            if (oldWidth != rc.width || oldHeight != rc.height) {
                doViewResize = true;
            }
            if (vbVis) {
                ScrollView.this.vertsb.setBounds(vbx, 0, wb, cs.y - cwh);
            }
            if (hbVis) {
                ScrollView.this.horzsb.setBounds(0, hby, cs.x - cww, hb);
            }
            if (ScrollView.this.cornerControl != null && ScrollView.this.cornerControl.getVisible()) {
                ScrollView.this.cornerControl.setBounds(vbx, hby, vbw, hbh);
            }
            ScrollView.this.updateScrollBarsValues();
            if (doViewResize) {
                ScrollView.this.viewResized();
            }
            --this.seek;
            if (this.seek == 0) {
                this.dontLayout = false;
            }
        }
    }

    private static class AutoScroll
    extends TimerTask {
        private int dx;
        private int dy;
        private ScrollView sv;

        public AutoScroll(ScrollView sv, int dx, int dy) {
            this.sv = sv;
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AutoScroll.this.sv.scrollBy(AutoScroll.this.dx, AutoScroll.this.dy);
                }
            });
        }
    }
}

