/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.view;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.log.viewer.views.msc.ui.view.ScrollView;

public class Overview {
    private static Cursor overviewCursor;
    private int overviewSize = 100;
    private ScrollView sv;
    private static final int MIN_SCROLL_VALUE = -50;
    private static final int MAX_SCROLL_VALUE = 50;
    private static final int MIN_EVENTTIME = 40;
    private float overviewFactorX;
    private float overviewFactorY;
    private Shell overview;
    private int saveCursorX;
    private int saveCursorY;
    private long lastTime;

    public Overview(ScrollView sv) {
        this.sv = sv;
    }

    public void useControl(Control c) {
        final Point pos = c.getLocation();
        c.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Overview.this.overviewAppear(e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                Overview.this.overviewDisappear();
            }
        });
        c.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (Overview.this.overviewing()) {
                    Overview.this.overviewMove(e);
                }
            }
        });
        c.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (Overview.this.overviewing()) {
                    Overview.this.overviewDisappear(false);
                }
            }
        });
        c.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32 && !Overview.this.overviewing()) {
                    Overview.this.overviewAppear(pos.x, pos.y);
                } else if (e.keyCode == 32) {
                    Overview.this.overviewDisappear();
                }
                if (e.keyCode == 0x1000002) {
                    Overview.this.overviewMove(0, 1, (TypedEvent)e);
                }
                if (e.keyCode == 0x1000001) {
                    Overview.this.overviewMove(0, -1, (TypedEvent)e);
                }
                if (e.keyCode == 0x1000004) {
                    Overview.this.overviewMove(1, 0, (TypedEvent)e);
                }
                if (e.keyCode == 0x1000003) {
                    Overview.this.overviewMove(-1, 0, (TypedEvent)e);
                }
            }
        });
    }

    public void dispose() {
        if (this.overview != null) {
            this.overview.dispose();
        }
    }

    private boolean overviewing() {
        return this.overview != null && this.overview.isVisible();
    }

    private void overviewAppear(int mx, int my) {
        if (this.overview == null) {
            this.overview = new Shell(this.sv.getShell(), 278528);
            this.overview.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Overview.this.sv.drawOverview(e.gc, Overview.this.overview.getClientArea());
                }
            });
        }
        this.overview.setForeground(this.sv.viewcontrol.getForeground());
        Point p = this.toGlobalCoordinates(this.sv.cornerControl, 0, 0);
        int x = p.x;
        int y = p.y;
        int w = this.overviewSize;
        int h = this.overviewSize;
        Rectangle scr = this.sv.getDisplay().getBounds();
        Point ccs = this.sv.cornerControl.getSize();
        try {
            float ratio;
            if (this.sv.contentsWidth > this.sv.contentsHeight) {
                ratio = (float)this.sv.contentsHeight / (float)this.sv.contentsWidth;
                h = (int)((float)w * ratio);
                if (h < ccs.y) {
                    h = ccs.y;
                } else if (h >= scr.height / 2) {
                    h = scr.height / 2;
                }
            } else {
                ratio = (float)this.sv.contentsWidth / (float)this.sv.contentsHeight;
                w = (int)((float)h * ratio);
                if (w < ccs.x) {
                    w = ccs.x;
                } else if (w >= scr.width / 2) {
                    w = scr.width / 2;
                }
            }
            this.overviewFactorX = (float)this.sv.contentsWidth / (float)w / 2.0f;
            this.overviewFactorY = (float)this.sv.contentsHeight / (float)h / 2.0f;
        }
        catch (ArithmeticException ratio) {
            // empty catch block
        }
        if (x <= 0) {
            x = 1;
        }
        if (y <= 0) {
            y = 1;
        }
        x = x - w + ccs.x;
        y = y - h + ccs.y;
        this.overview.setBounds(x, y, w, h);
        this.overview.setVisible(true);
        this.overview.redraw(x, y, w, h, false);
        if (overviewCursor == null) {
            RGB[] rgb = new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0)};
            PaletteData pal = new PaletteData(rgb);
            int s = 1;
            byte[] src = new byte[s * s];
            byte[] msk = new byte[s * s];
            for (int i = 0; i < s * s; ++i) {
                src[i] = -1;
            }
            ImageData iSrc = new ImageData(s, s, 1, pal, 1, src);
            ImageData iMsk = new ImageData(s, s, 1, pal, 1, msk);
            overviewCursor = new Cursor(null, iSrc, iMsk, 0, 0);
        }
        this.sv.cornerControl.setCursor(overviewCursor);
        p = this.toGlobalCoordinates(this.sv.cornerControl, mx, my);
        this.saveCursorX = p.x;
        this.saveCursorY = p.y;
        Rectangle r = this.overview.getClientArea();
        int cx = (int)((float)(r.width * this.sv.contentsX) / (float)this.sv.contentsWidth);
        int cy = (int)((float)(r.height * this.sv.contentsY) / (float)this.sv.contentsHeight);
        p = this.toGlobalCoordinates((Control)this.overview.getParent(), cx, cy);
        cx = p.x;
        cy = p.y;
    }

    private void overviewDisappear() {
        this.overviewDisappear(true);
    }

    private void overviewDisappear(boolean restoreCursorLoc) {
        if (this.overview == null) {
            return;
        }
        this.overview.setVisible(false);
        this.sv.cornerControl.setCursor(null);
        if (restoreCursorLoc) {
            this.sv.getDisplay().setCursorLocation(this.saveCursorX, this.saveCursorY);
        }
        this.overview.dispose();
        this.overview = null;
        this.sv.setFocus();
    }

    private void overviewMove(MouseEvent event) {
        Point p = this.toGlobalCoordinates(this.sv.cornerControl, event.x, event.y);
        int dx = p.x - this.saveCursorX;
        int dy = p.y - this.saveCursorY;
        if (dx == 0 && dy == 0) {
            return;
        }
        long time = 0xFFFFFFFFL & (long)event.time;
        if (time == this.lastTime) {
            return;
        }
        if (time > this.lastTime && time - this.lastTime < 40L) {
            return;
        }
        this.lastTime = time;
        if (dx < -50) {
            dx = -50;
        } else if (dx > 50) {
            dx = 50;
        }
        if (dy < -50) {
            dy = -50;
        } else if (dy > 50) {
            dy = 50;
        }
        this.overviewMove(dx, dy, (TypedEvent)event);
    }

    private void overviewMove(int dx, int dy, TypedEvent event) {
        MouseEvent e;
        boolean ctrl = false;
        boolean shift = false;
        if (event instanceof MouseEvent) {
            e = (MouseEvent)event;
            this.sv.getDisplay().setCursorLocation(this.saveCursorX, this.saveCursorY);
            ctrl = (e.stateMask & 0x40000) != 0;
            shift = (e.stateMask & 0x20000) != 0;
        } else if (event instanceof KeyEvent) {
            e = (KeyEvent)event;
            ctrl = (e.stateMask & 0x40000) != 0;
            shift = (e.stateMask & 0x20000) != 0;
        }
        int cx = this.sv.contentsX;
        int cy = this.sv.contentsY;
        float fx = this.overviewFactorX;
        float fy = this.overviewFactorY;
        if (ctrl && shift) {
            if (fx * 0.25f > 1.0f && (double)fy * 0.25 > 1.0) {
                fx = 1.0f;
                fy = 1.0f;
            } else {
                fx *= 0.1f;
                fy *= 0.1f;
            }
        } else if (ctrl) {
            fx *= 0.5f;
            fy *= 0.5f;
        } else if (shift) {
            fx *= 0.5f;
            fy *= 0.5f;
        }
        this.sv.scrollBy((int)(fx * (float)dx), (int)(fy * (float)dy));
        if ((cx != this.sv.contentsX || cy != this.sv.contentsY) && this.overview != null) {
            this.overview.redraw();
            this.overview.update();
        }
    }

    protected Point toGlobalCoordinates(Control loc, int x, int y) {
        Point p = new Point(x, y);
        for (Control c = loc; c != null; c = c.getParent()) {
            int trimX = 0;
            int trimY = 0;
            if (c instanceof Scrollable) {
                Scrollable s = (Scrollable)c;
                Rectangle rr = s.getClientArea();
                Rectangle tr = s.computeTrim(rr.x, rr.y, rr.width, rr.height);
                trimX = rr.x - tr.x;
                trimY = rr.y - tr.y;
            }
            p.x += c.getLocation().x + trimX;
            p.y += c.getLocation().y + trimY;
        }
        return p;
    }

    public void setOverviewSize(int size) {
        this.overviewSize = Math.abs(size);
    }
}

