/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.common;

import org.eclipse.efm.sew.launcher.workflow.common.TraceElement;
import org.eclipse.efm.sew.launcher.workflow.common.TraceElementCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.TraceElementKind;
import org.eclipse.efm.sew.launcher.workflow.common.impl.TraceSpecificationImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;
import org.eclipse.emf.common.util.EList;

public class TraceSpecificationCustomImpl
extends TraceSpecificationImpl {
    public TraceSpecificationCustomImpl(String name) {
        this.setName(name);
    }

    public static TraceSpecificationCustomImpl create(String name) {
        return new TraceSpecificationCustomImpl(name);
    }

    public static TraceSpecificationCustomImpl create(String name, String specification) {
        TraceSpecificationCustomImpl trace = new TraceSpecificationCustomImpl(name);
        trace.parseAll(specification);
        return trace;
    }

    public void parseAll(String specification) {
        this.parseAll(specification, TraceElementKind.UNKNOWN);
    }

    public void parseAll(String specification, TraceElementKind defaultNature) {
        if (specification == null) {
            return;
        }
        if ((specification = specification.trim()).isEmpty()) {
            return;
        }
        String[] tabString = specification.split("\\R|;");
        EList<TraceElement> elements = this.getElement();
        String[] stringArray = tabString;
        int n = tabString.length;
        int n2 = 0;
        while (n2 < n) {
            TraceElementCustomImpl traceElt;
            String eltString = stringArray[n2];
            if ((eltString = eltString.trim()).length() != 0 && (traceElt = TraceElementCustomImpl.create(eltString, defaultNature)) != null) {
                elements.add((Object)traceElt);
            }
            ++n2;
        }
    }

    public void toWriter(PrettyPrintWriter writer) {
        writer.commentLine(this.getComment());
        writer.appendTab();
        String name = this.getName();
        if (name == null) {
            name = "trace";
        }
        writer.append(name);
        String str = this.getDescription();
        if (str != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" [");
        PrettyPrintWriter writer2 = writer.itab2();
        for (TraceElement element : this.getElement()) {
            if (element instanceof TraceElementCustomImpl) {
                ((TraceElementCustomImpl)element).toWriter(writer2);
                continue;
            }
            writer.appendTab2(element.getNature().getLiteral()).append(" = ").appendEol(element.getValue() != null ? element.getValue().toString() : "'<null>'");
        }
        writer.appendTab("] // end ").appendEol(name);
    }
}

