/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui.internal.fieldeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IntegerFieldEditor
extends StringFieldEditor {
    private int fDefaultValue;
    private int minValidValue = -1;
    private int maxValidValue = Integer.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    public IntegerFieldEditor(AbstractSewLaunchConfigurationTab launchConfigurationTab, String storeKey, String labelText, Composite parent, int defaultValue) {
        this(launchConfigurationTab, storeKey, labelText, parent, 10, defaultValue);
    }

    public IntegerFieldEditor(AbstractSewLaunchConfigurationTab launchConfigurationTab, String storeKey, String labelText, Composite parent, int textLimit, int defaultValue) {
        super(Integer.toString(defaultValue), true);
        this.fDefaultValue = defaultValue;
        this.init(launchConfigurationTab, storeKey, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    public void setValidRange(int min, int max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.setErrorMessage(JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{new Integer(min), new Integer(max)}));
    }

    @Override
    protected boolean checkState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                int number = Integer.valueOf(numberString);
                if (number < this.minValidValue || number > this.maxValidValue) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(this.getStoreKey(), this.fDefaultValue);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.setStringValue(Integer.toString(configuration.getAttribute(this.getStoreKey(), this.fDefaultValue)));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid()) {
            try {
                configuration.setAttribute(this.getStoreKey(), this.getIntValue());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    public int getIntValue() throws NumberFormatException {
        String value = this.getStringValue();
        return value.isEmpty() ? this.fDefaultValue : Integer.parseInt(value);
    }
}

