/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Receive_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.implementation.SuperfluousTemplate;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class ReceiveAnyTemplate
extends BaseModuleCodeSmellSpotter {
    private static final String CAN_RECEIVE_ANY_OF_ONE = "Template instance of the receives statement matches any possible message,which might not be a problem as the port can only send one type of message";
    private static final String CAN_RECEIVE_ANY_OF_MULTIPLE = "Template instance of the receives statement matches any possible message,which might be a problem as the port can send more type of message, thus value redirection is semantically invalid";

    public ReceiveAnyTemplate() {
        super(CodeSmellType.RECEIVE_ANY_TEMPLATE);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Operation_Altguard ag;
        Statement action;
        if (node instanceof Operation_Altguard && (action = (ag = (Operation_Altguard)node).getGuardStatement()) instanceof Receive_Port_Statement) {
            Receive_Port_Statement receive = (Receive_Port_Statement)action;
            SuperfluousTemplate st = new SuperfluousTemplate(receive);
            receive.accept((ASTVisitor)st);
            if (st.canReceiveAny() && st.hasValueRedirect()) {
                if (st.getReceivable() == null) {
                    problems.report(receive.getLocation(), CAN_RECEIVE_ANY_OF_MULTIPLE);
                } else {
                    problems.report(receive.getLocation(), CAN_RECEIVE_ANY_OF_ONE);
                }
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(AltGuard.class);
        return ret;
    }
}

