/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.applications.InformationExporter;
import org.eclipse.titanium.utils.SonarDataExporter;

public class ExportDataForSonar
extends InformationExporter {
    private List<IProject> projectsToExport = new ArrayList<IProject>();

    @Override
    protected boolean checkParameters(String[] args) {
        if (args.length == 0) {
            this.projectsToExport = this.getAllAccessibleProjects();
            return true;
        }
        if (args.length != 2) {
            this.printUsage();
            return false;
        }
        if (!"-p".equals(args[0]) && "--projects".equals(args[0])) {
            this.printUsage();
            return false;
        }
        List<String> projectNames = Arrays.asList(args[1].split(","));
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (String name : projectNames) {
            IProject project = wsRoot.getProject(name);
            if (!project.isAccessible()) {
                System.out.println("Project '" + name + "' is not accessible.");
                return false;
            }
            this.projectsToExport.add(project);
        }
        return true;
    }

    private void printUsage() {
        String applicationName = ExportDataForSonar.class.getCanonicalName();
        System.out.println("Usage: ./eclipse " + applicationName + " [-p project1,project2,...,projectN]");
    }

    @Override
    protected void exportInformationForProject(String[] args, IProject project, IProgressMonitor monitor) {
        SonarDataExporter exporter = new SonarDataExporter(project);
        try {
            exporter.exportDataForProject();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while exporting data for project " + project.getName()), (Throwable)e);
        }
    }

    @Override
    protected List<IProject> getProjectsToHandle() {
        return this.projectsToExport;
    }
}

