/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKind;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class TestKindRegistry {
    public static final String JUNIT3_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit3";
    public static final String JUNIT4_TEST_KIND_ID = "org.eclipse.jdt.junit.loader.junit4";
    private static TestKindRegistry fgRegistry;
    private final IExtensionPoint fPoint;
    private ArrayList<TestKind> fTestKinds;

    public static TestKindRegistry getDefault() {
        if (fgRegistry != null) {
            return fgRegistry;
        }
        fgRegistry = new TestKindRegistry(Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.junit.internal_testKinds"));
        return fgRegistry;
    }

    private TestKindRegistry(IExtensionPoint point) {
        this.fPoint = point;
    }

    public ArrayList<TestKind> getAllKinds() {
        this.loadKinds();
        return this.fTestKinds;
    }

    private void loadKinds() {
        if (this.fTestKinds != null) {
            return;
        }
        ArrayList<TestKind> items = new ArrayList<TestKind>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            items.add(new TestKind(element));
        }
        Collections.sort(items, new Comparator<TestKind>(){

            @Override
            public int compare(TestKind kind0, TestKind kind1) {
                if (kind0.precedes(kind1)) {
                    return -1;
                }
                if (kind1.precedes(kind0)) {
                    return 1;
                }
                return 0;
            }
        });
        this.fTestKinds = items;
    }

    public ArrayList<String> getDisplayNames() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<TestKind> testTypes = this.getAllKinds();
        for (ITestKind iTestKind : testTypes) {
            result.add(iTestKind.getDisplayName());
        }
        return result;
    }

    public ITestKind getKind(String testKindId) {
        if (testKindId != null) {
            for (TestKind kind : this.getAllKinds()) {
                if (!testKindId.equals(kind.getId())) continue;
                return kind;
            }
        }
        return ITestKind.NULL;
    }

    public static String getContainerTestKindId(IJavaElement element) {
        IJavaProject project;
        if (element != null && CoreTestSearchEngine.is50OrHigher(project = element.getJavaProject()) && CoreTestSearchEngine.hasTestAnnotation(project)) {
            return JUNIT4_TEST_KIND_ID;
        }
        return JUNIT3_TEST_KIND_ID;
    }

    public static ITestKind getContainerTestKind(IJavaElement element) {
        return TestKindRegistry.getDefault().getKind(TestKindRegistry.getContainerTestKindId(element));
    }

    private ArrayList<IConfigurationElement> getConfigurationElements() {
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IExtension[] extensions = this.fPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                items.add(element);
                ++j;
            }
            ++i;
        }
        return items;
    }

    public String getAllKindIds() {
        ArrayList<TestKind> allKinds = this.getAllKinds();
        String returnThis = "";
        for (ITestKind iTestKind : allKinds) {
            returnThis = String.valueOf(returnThis) + "(" + iTestKind.getId() + ")";
        }
        return returnThis;
    }
}

