/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.PRectangle;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.widgets.MenuItem;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu {
    protected double width = 200.0;
    protected static final double DEFAULT_ITEM_HEIGHT = 25.0;
    protected static final Color DEFAULT_MENU_BGCOLOR = new Color(70, 70, 70);
    protected static final Color DEFAULT_MENU_HCOLOR = new Color(120, 120, 120);
    protected static final Color DEFAULT_MENU_LBCOLOR = Color.WHITE;
    protected Color MENU_BGCOLOR = DEFAULT_MENU_BGCOLOR;
    protected Color MENU_HCOLOR = DEFAULT_MENU_HCOLOR;
    protected Color MENU_LBCOLOR = DEFAULT_MENU_LBCOLOR;
    protected short LABEL_ANCHOR = 1;
    protected static final String MENU_BOX_TYPE = "MENU_BOX";
    protected final VirtualSpace space;
    protected final List<Glyph> elems = new ArrayList<Glyph>();

    public Menu(VirtualSpace space) {
        this.space = space;
    }

    public Menu(VirtualSpace space, Color bgColor, Color hColor, Color lColor, short labelAnchor) {
        this.space = space;
        this.MENU_BGCOLOR = bgColor;
        this.MENU_HCOLOR = hColor;
        this.MENU_LBCOLOR = lColor;
        this.LABEL_ANCHOR = labelAnchor;
    }

    public void show() {
        for (Glyph elem : this.elems) {
            this.space.show(elem);
        }
    }

    public void hide() {
        for (Glyph elem : this.elems) {
            this.space.hide(elem);
        }
    }

    public void clear() {
        for (Glyph elem : this.elems) {
            this.space.removeGlyph(elem);
        }
        this.elems.clear();
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("setWidth: positive value expected");
        }
        this.width = width;
    }

    protected VText makeLabel(MenuItem item, double xpos, double ypos) {
        VText retval = new VText(xpos, ypos, 0, DEFAULT_MENU_LBCOLOR, item.getText());
        retval.setTextAnchor(this.LABEL_ANCHOR);
        return retval;
    }

    public void populate(List<MenuItem> items, Point2D.Double coords) {
        double xpos = coords.getX();
        double ypos = coords.getY();
        for (MenuItem item : items) {
            PRectangle<MenuItem> menuBox = new PRectangle<MenuItem>(xpos, ypos, 0, this.width, 25.0, Utils.makeDiagGradient((float)this.width, 25.0f, this.MENU_BGCOLOR));
            menuBox.setCursorInsidePaint(Utils.makeDiagGradient((float)this.width, 25.0f, this.MENU_HCOLOR));
            menuBox.setType(MENU_BOX_TYPE);
            menuBox.setOwner(item);
            VText label = this.makeLabel(item, xpos, ypos);
            label.setSensitivity(false);
            this.elems.add(menuBox);
            this.elems.add(label);
            this.space.addGlyph(menuBox);
            this.space.addGlyph(label);
            ypos -= 26.0;
        }
    }

    public MenuItem getItemForGlyph(Glyph glyph) {
        int idx = this.elems.indexOf(glyph);
        if (idx == -1) {
            return null;
        }
        assert (this.elems.get(idx).getOwner() instanceof MenuItem);
        return (MenuItem)this.elems.get(idx).getOwner();
    }

    public void onEnterGlyph(Glyph g) {
        if (g.getType().equals(MENU_BOX_TYPE) && this.elems.contains(g)) {
            g.highlight(true, null);
        }
    }

    public void onExitGlyph(Glyph g) {
        if (g.getType().equals(MENU_BOX_TYPE) && this.elems.contains(g)) {
            g.highlight(false, null);
        }
    }
}

