/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class FileDiffLabelProvider
extends ColumnLabelProvider {
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final Color dimmedForegroundColor;

    public FileDiffLabelProvider(RGB dimmedForegroundRgb) {
        this.dimmedForegroundColor = this.resourceManager.createColor(dimmedForegroundRgb);
    }

    public String getText(Object element) {
        return ((FileDiff)((Object)element)).getLabel(element);
    }

    public Image getImage(Object element) {
        FileDiff c = (FileDiff)((Object)element);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)c.getImageDescriptor((Object)c));
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public Color getForeground(Object element) {
        FileDiff c = (FileDiff)((Object)element);
        if (!c.isMarked(0)) {
            return this.dimmedForegroundColor;
        }
        return null;
    }

    public String getToolTipText(Object element) {
        FileDiff c = (FileDiff)((Object)element);
        if (c.getChange() == DiffEntry.ChangeType.RENAME) {
            return MessageFormat.format(UIText.FileDiffLabelProvider_RenamedFromToolTip, c.getOldPath());
        }
        return null;
    }
}

