/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.HashSet;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PDELabelUtility {
    public static String getFieldLabel(Control control) {
        int ampIndex;
        Control[] controls = control.getParent().getChildren();
        if (controls.length == 0) {
            return null;
        }
        int myIndex = -1;
        int i = 0;
        while (i < controls.length) {
            if (controls[i] == control) {
                myIndex = i;
                break;
            }
            ++i;
        }
        if (myIndex <= 0) {
            return null;
        }
        int labelIndex = myIndex - 1;
        if (!(controls[labelIndex] instanceof Label)) {
            return null;
        }
        String labelText = ((Label)controls[labelIndex]).getText();
        int colonIndex = labelText.indexOf(58);
        if (colonIndex >= 0) {
            labelText = labelText.replaceAll(":", "");
        }
        if ((ampIndex = labelText.indexOf(38)) >= 0) {
            labelText = labelText.replaceAll("&", "");
        }
        return labelText;
    }

    public static String qualifyMessage(String qualification, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(qualification);
        buffer.append(':');
        buffer.append(' ');
        buffer.append(message);
        return buffer.toString();
    }

    private static void addNumberToBase(StringBuffer base, boolean bracketed, HashSet<Integer> set) {
        if (set.size() > 0) {
            int limit = 100;
            if (set.contains(0)) {
                int x = 1;
                while (x < limit) {
                    if (!set.contains(x)) {
                        if (bracketed) {
                            base.append(" (");
                        }
                        base.append(x);
                        if (!bracketed) break;
                        base.append(")");
                        break;
                    }
                    ++x;
                }
            }
        }
    }

    private static void compareTitleWithBase(String base, boolean bracketed, HashSet<Integer> set, String title) {
        if (title.toLowerCase().startsWith(base.toLowerCase())) {
            int minSizeNumAddOn = 4;
            if (!bracketed) {
                minSizeNumAddOn = 1;
            }
            if (title.length() >= base.length() + minSizeNumAddOn) {
                String numPart;
                if (bracketed && title.charAt(base.length()) == ' ') {
                    numPart = title.substring(base.length() + 1);
                } else if (!bracketed) {
                    numPart = title.substring(base.length());
                } else {
                    return;
                }
                if (bracketed) {
                    if (numPart.charAt(0) == '(') {
                        numPart = numPart.substring(1);
                    } else {
                        return;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                int j = 0;
                while (j < numPart.length()) {
                    char current = numPart.charAt(j);
                    if (Character.isDigit(current)) {
                        buffer.append(current);
                    } else if (!bracketed || numPart.charAt(j) != ')' || j != numPart.length() - 1) {
                        return;
                    }
                    ++j;
                }
                if (buffer.length() > 0) {
                    set.add(Integer.valueOf(buffer.toString()));
                }
            } else {
                set.add(0);
            }
        }
    }

    public static String generateName(String[] names, String base) {
        return PDELabelUtility.generateName(names, base, true);
    }

    public static String generateName(String[] names, String base, boolean bracketed) {
        StringBuffer result = new StringBuffer(base);
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        while (i < names.length) {
            PDELabelUtility.compareTitleWithBase(base, bracketed, set, names[i]);
            ++i;
        }
        PDELabelUtility.addNumberToBase(result, bracketed, set);
        return result.toString();
    }

    public static String getBaseName(String name, boolean bracketed) {
        String result = name;
        if (bracketed) {
            if (result.charAt(result.length() - 1) != ')') {
                return name;
            }
            result = result.substring(0, result.length() - 1);
        }
        while (Character.isDigit(result.charAt(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        if (bracketed) {
            if (!result.substring(result.length() - 2).equals(" (")) {
                return name;
            }
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }
}

