/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Objects;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.util.MergeableManifest;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.TextFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

@Log
@Accessors
public class ManifestAccess
extends TextFileAccess
implements IGuiceAwareGeneratorComponent {
    private String bundleName;
    private String symbolicName;
    private String version = "0.0.1.qualifier";
    private boolean merge = true;
    private final Set<String> exportedPackages = CollectionLiterals.newHashSet((Object[])new String[0]);
    private final Set<String> requiredBundles = CollectionLiterals.newHashSet((Object[])new String[0]);
    private final Set<String> importedPackages = CollectionLiterals.newHashSet((Object[])new String[0]);
    private TypeReference activator;
    private static final Logger LOG = Logger.getLogger(ManifestAccess.class);

    public ManifestAccess() {
        this.setPath("MANIFEST.MF");
    }

    public boolean merge(ManifestAccess other) {
        boolean _notEquals_5;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        String _path_1;
        boolean _notEquals;
        boolean _xblockexpression = false;
        String _path = this.getPath();
        boolean bl = _notEquals = !Objects.equal((Object)_path, (Object)(_path_1 = other.getPath()));
        if (_notEquals) {
            String _path_2 = this.getPath();
            String _plus = "Merging manifest files with different paths: " + _path_2;
            String _plus_1 = String.valueOf(_plus) + ", ";
            String _path_3 = other.getPath();
            String _plus_2 = String.valueOf(_plus_1) + _path_3;
            LOG.warn((Object)_plus_2);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)this.bundleName, (Object)other.bundleName);
        if (_notEquals_1) {
            if (this.bundleName == null) {
                this.bundleName = other.bundleName;
            } else if (other.bundleName != null) {
                LOG.warn((Object)("Merging manifest files with different bundle names: " + this.bundleName + ", " + other.bundleName));
            }
        }
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)this.symbolicName, (Object)other.symbolicName);
        if (_notEquals_2) {
            if (this.symbolicName == null) {
                this.symbolicName = other.symbolicName;
            } else if (other.symbolicName != null) {
                LOG.warn((Object)("Merging manifest files with different symbolic names: " + this.symbolicName + ", " + other.symbolicName));
            }
        }
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)this.activator, (Object)other.activator);
        if (_notEquals_3) {
            if (this.activator == null) {
                this.activator = other.activator;
            } else if (other.activator != null) {
                LOG.warn((Object)("Merging manifest files with different activators: " + this.activator + ", " + other.activator));
            }
        }
        boolean bl5 = _notEquals_4 = !Objects.equal((Object)this.version, (Object)other.version);
        if (_notEquals_4) {
            LOG.warn((Object)("Merging manifest files with different versions: " + this.version + ", " + other.version));
        }
        if (this.merge != other.merge) {
            LOG.warn((Object)"Merging manifest files with different merging settings.");
        }
        this.exportedPackages.addAll(other.exportedPackages);
        this.requiredBundles.addAll(other.requiredBundles);
        boolean bl6 = _notEquals_5 = !Objects.equal((Object)this.symbolicName, null);
        if (_notEquals_5) {
            String _effectiveSymbolicName = this.getEffectiveSymbolicName();
            this.requiredBundles.remove(_effectiveSymbolicName);
        }
        _xblockexpression = this.importedPackages.addAll(other.importedPackages);
        return _xblockexpression;
    }

    public String getEffectiveSymbolicName() {
        if (this.symbolicName == null) {
            return null;
        }
        int idx = this.symbolicName.indexOf(";");
        if (idx < 0) {
            return this.symbolicName;
        }
        return this.symbolicName.substring(0, idx);
    }

    @Override
    public void setContent(StringConcatenationClient content) {
        throw new UnsupportedOperationException("cannot directly set 'content' on a manifest.mf. Use the individual properties instead.");
    }

    @Override
    public CharSequence getContent() {
        boolean _isEmpty_2;
        boolean _not_3;
        boolean _isEmpty_1;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Manifest-Version: 1.0");
        _builder.newLine();
        _builder.append((Object)"Bundle-ManifestVersion: 2");
        _builder.newLine();
        _builder.append((Object)"Bundle-Name: ");
        _builder.append((Object)this.bundleName, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"Bundle-SymbolicName: ");
        String _elvis = null;
        _elvis = this.symbolicName != null ? this.symbolicName : this.bundleName;
        _builder.append((Object)_elvis, "");
        _builder.append((Object)";singleton:=true");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.version);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)"Bundle-Version: ");
            _builder.append((Object)this.version, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"Bundle-RequiredExecutionEnvironment: JavaSE-1.6");
        _builder.newLine();
        _builder.append((Object)"Bundle-ActivationPolicy: lazy");
        _builder.newLine();
        boolean _isEmpty = this.exportedPackages.isEmpty();
        boolean bl2 = _not_1 = !_isEmpty;
        if (_not_1) {
            _builder.append((Object)"Export-Package: ");
            List _sort = IterableExtensions.sort(this.exportedPackages);
            boolean _hasElements = false;
            for (String pack : _sort) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n ", "");
                }
                _builder.append((Object)pack, "");
            }
            _builder.newLineIfNotEmpty();
        }
        boolean bl3 = _not_2 = !(_isEmpty_1 = this.requiredBundles.isEmpty());
        if (_not_2) {
            _builder.append((Object)"Require-Bundle: ");
            List _sort_1 = IterableExtensions.sort(this.requiredBundles);
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    String _effectiveSymbolicName = ManifestAccess.this.getEffectiveSymbolicName();
                    return !Objects.equal((Object)it, (Object)_effectiveSymbolicName);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_sort_1, (Functions.Function1)_function);
            boolean _hasElements_1 = false;
            for (String bundle : _filter) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)",\n ", "");
                }
                _builder.append((Object)bundle, "");
            }
            _builder.newLineIfNotEmpty();
        }
        boolean bl4 = _not_3 = !(_isEmpty_2 = this.importedPackages.isEmpty());
        if (_not_3) {
            _builder.append((Object)"Import-Package: ");
            List _sort_2 = IterableExtensions.sort(this.importedPackages);
            boolean _hasElements_2 = false;
            for (String pack_1 : _sort_2) {
                if (!_hasElements_2) {
                    _hasElements_2 = true;
                } else {
                    _builder.appendImmediate((Object)",\n ", "");
                }
                _builder.append((Object)pack_1, "");
            }
            _builder.newLineIfNotEmpty();
        }
        if (this.activator != null) {
            _builder.append((Object)"Bundle-Activator: ");
            _builder.append((Object)this.activator, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Override
    public void writeTo(IFileSystemAccess2 fileSystemAccess) {
        try {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)fileSystemAccess, null);
            if (_notEquals) {
                CharSequence _content = this.getContent();
                StringBuffer _stringBuffer = new StringBuffer(_content);
                String contentToWrite = MergeableManifest.make512Safe((StringBuffer)_stringBuffer);
                byte[] _bytes = contentToWrite.getBytes("UTF-8");
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
                MergeableManifest mergableManifest = new MergeableManifest((InputStream)_byteArrayInputStream);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                mergableManifest.write((OutputStream)bout);
                String _path = this.getPath();
                byte[] _byteArray = bout.toByteArray();
                ByteArrayInputStream _byteArrayInputStream_1 = new ByteArrayInputStream(_byteArray);
                fileSystemAccess.generateFile(_path, (InputStream)_byteArrayInputStream_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    @Pure
    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    @Pure
    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    @Pure
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Pure
    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    @Pure
    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    @Pure
    public Set<String> getRequiredBundles() {
        return this.requiredBundles;
    }

    @Pure
    public Set<String> getImportedPackages() {
        return this.importedPackages;
    }

    @Pure
    public TypeReference getActivator() {
        return this.activator;
    }

    public void setActivator(TypeReference activator) {
        this.activator = activator;
    }
}

