/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.SwingWorker;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.SVGReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.claribole.zgrviewer.AppletUtils;
import net.claribole.zgrviewer.CallBox;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.DOTManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.ZGRViewer;
import org.w3c.dom.Document;

class GVLoader {
    Object application;
    GraphicsManager grMngr;
    ConfigManager cfgMngr;
    DOTManager dotMngr;

    GVLoader(Object app, GraphicsManager gm, ConfigManager cm, DOTManager dm) {
        this.application = app;
        this.grMngr = gm;
        this.cfgMngr = cm;
        this.dotMngr = dm;
    }

    void open(short prg, boolean parser) {
        if (ConfigManager.checkProgram(prg)) {
            this.openDOTFile(prg, parser);
        } else {
            Object[] options = new Object[]{"Yes", "No"};
            int option = JOptionPane.showOptionDialog(null, ConfigManager.getDirStatus(), "Warning", -1, 2, null, options, options[0]);
            if (option == 0) {
                this.openDOTFile(prg, parser);
            }
        }
    }

    void openDOTFile(final short prg, final boolean parser) {
        final JFileChooser fc = new JFileChooser(ConfigManager.m_LastDir != null ? ConfigManager.m_LastDir : ConfigManager.m_PrjDir);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Find DOT File");
        int returnVal = fc.showOpenDialog(this.grMngr.mainView.getFrame());
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    GVLoader.this.grMngr.reset();
                    GVLoader.this.loadFile(fc.getSelectedFile(), prg, parser);
                    return null;
                }
            };
            worker.start();
        }
    }

    void openSVGFile() {
        final JFileChooser fc = new JFileChooser(ConfigManager.m_LastDir != null ? ConfigManager.m_LastDir : ConfigManager.m_PrjDir);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Find SVG File");
        int returnVal = fc.showOpenDialog(this.grMngr.mainView.getFrame());
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    GVLoader.this.grMngr.reset();
                    GVLoader.this.loadSVG(fc.getSelectedFile());
                    return null;
                }
            };
            worker.start();
        }
    }

    void openOther() {
        new CallBox((ZGRViewer)this.application, this.grMngr);
    }

    void loadFile(File f, short prg, boolean parser) {
        if (f.exists()) {
            ConfigManager.m_LastDir = f.getParentFile();
            this.cfgMngr.lastFileOpened = f;
            this.dotMngr.lastProgramUsed = prg;
            if (this.grMngr.mainView.isBlank() == null) {
                this.grMngr.mainView.setBlank(this.cfgMngr.backgroundColor);
            }
            this.dotMngr.load(f, prg, parser);
            ConfigManager.defaultFont = VText.getMainFont();
            this.grMngr.mainView.setTitle("ZGRViewer - " + f.getAbsolutePath());
            this.grMngr.reveal();
            if (this.grMngr.previousLocations.size() == 1) {
                this.grMngr.previousLocations.removeElementAt(0);
            }
            if (this.grMngr.rView != null) {
                this.grMngr.rView.getGlobalView(this.grMngr.mSpace.getCamera(1), 100);
                this.grMngr.cameraMoved(null, null, 0.0);
            }
            this.cfgMngr.notifyPlugins((short)5);
        }
    }

    void loadSVG(File f) {
        this.grMngr.gp.setMessage("Parsing SVG...");
        this.grMngr.gp.setProgress(10);
        this.grMngr.gp.setVisible(true);
        try {
            this.grMngr.gp.setProgress(30);
            this.cfgMngr.lastFileOpened = f;
            this.dotMngr.lastProgramUsed = (short)4;
            Document svgDoc = f.getName().toLowerCase().endsWith(".svgz") ? Utils.parse(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))), false) : Utils.parse(f, false);
            this.grMngr.gp.setMessage("Building graph...");
            this.grMngr.gp.setProgress(80);
            if (this.grMngr.mainView.isBlank() == null) {
                this.grMngr.mainView.setBlank(this.cfgMngr.backgroundColor);
            }
            SVGReader.load(svgDoc, this.grMngr.mSpace, true, f.toURI().toURL().toString());
            this.grMngr.seekBoundingBox();
            this.grMngr.buildLogicalStructure();
            ConfigManager.defaultFont = VText.getMainFont();
            this.grMngr.mainView.setTitle("ZGRViewer - " + f.getAbsolutePath());
            this.grMngr.reveal();
            if (this.grMngr.previousLocations.size() == 1) {
                this.grMngr.previousLocations.removeElementAt(0);
            }
            if (this.grMngr.rView != null) {
                this.grMngr.rView.getGlobalView(this.grMngr.mSpace.getCamera(1), 100);
                this.grMngr.cameraMoved(null, null, 0.0);
            }
            this.grMngr.gp.setVisible(false);
            this.cfgMngr.notifyPlugins((short)5);
        }
        catch (Exception ex) {
            this.grMngr.reveal();
            this.grMngr.gp.setVisible(false);
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "An error occured while loading from " + f.toString());
        }
    }

    void loadSVG(String svgFileURL) {
        try {
            Document svgDoc;
            URL url = new URL(svgFileURL);
            URLConnection c = url.openConnection();
            c.setRequestProperty("Accept-Encoding", "gzip");
            InputStream is = c.getInputStream();
            String encoding = c.getContentEncoding();
            if ("gzip".equals(encoding) || "x-gzip".equals(encoding) || svgFileURL.toLowerCase().endsWith(".svgz")) {
                is = new GZIPInputStream(is);
            }
            if ((svgDoc = AppletUtils.parse(is = new BufferedInputStream(is), false)) != null) {
                if (this.grMngr.mainView.isBlank() == null) {
                    this.grMngr.mainView.setBlank(this.cfgMngr.backgroundColor);
                }
                SVGReader.load(svgDoc, this.grMngr.mSpace, true, svgFileURL);
                this.grMngr.seekBoundingBox();
                this.grMngr.buildLogicalStructure();
                ConfigManager.defaultFont = VText.getMainFont();
                this.grMngr.reveal();
                if (this.grMngr.previousLocations.size() == 1) {
                    this.grMngr.previousLocations.removeElementAt(0);
                }
                if (this.grMngr.rView != null) {
                    this.grMngr.rView.getGlobalView(this.grMngr.mSpace.getCamera(1), 100);
                }
                this.grMngr.cameraMoved(null, null, 0.0);
            } else {
                System.err.println("An error occured while loading file " + svgFileURL);
            }
        }
        catch (Exception ex) {
            this.grMngr.reveal();
            ex.printStackTrace();
        }
    }

    void load(String commandLine, String sourceFile) {
        this.grMngr.reset();
        this.dotMngr.loadCustom(sourceFile, commandLine);
        ConfigManager.defaultFont = VText.getMainFont();
        this.grMngr.mainView.setTitle("ZGRViewer - " + sourceFile);
        this.grMngr.reveal();
        if (this.grMngr.previousLocations.size() == 1) {
            this.grMngr.previousLocations.removeElementAt(0);
        }
        if (this.grMngr.rView != null) {
            this.grMngr.rView.getGlobalView(this.grMngr.mSpace.getCamera(1), 100);
            this.grMngr.cameraMoved(null, null, 0.0);
        }
        this.cfgMngr.notifyPlugins((short)5);
    }

    void reloadFile() {
        if (this.cfgMngr.lastFileOpened != null) {
            this.grMngr.reset();
            if (this.dotMngr.lastProgramUsed == 4) {
                this.loadSVG(this.cfgMngr.lastFileOpened);
            } else {
                this.loadFile(this.cfgMngr.lastFileOpened, this.dotMngr.lastProgramUsed, false);
            }
        }
    }
}

