/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VRectangle;
import java.awt.Color;

public class Transitions {
    public static void fadeOut(View v, int duration, Color fadeColor) {
        Transitions.fadeOut(v, duration, fadeColor, null);
    }

    public static void fadeOut(final View v, int duration, final Color fadeColor, final EndAction action) {
        if (v.isBlank() != null) {
            return;
        }
        final Camera c = v.getCameraNumber(v.getLayerCount() - 1);
        double[] wnes = v.getVisibleRegion(c);
        final VRectangle fadeRect = new VRectangle((wnes[0] + wnes[2]) / 2.0, (wnes[1] + wnes[3]) / 2.0, 0, wnes[2] - wnes[0], wnes[1] - wnes[3], fadeColor, fadeColor, 0.0f);
        fadeRect.setDrawBorder(false);
        c.getOwningSpace().addGlyph(fadeRect);
        Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createTranslucencyAnim(duration, fadeRect, 1.0f, false, IdentityInterpolator.getInstance(), new EndAction(){

            public void execute(Object subject, Animation.Dimension dimension) {
                v.setBlank(fadeColor);
                c.getOwningSpace().removeGlyph(fadeRect);
                if (null != action) {
                    action.execute(subject, dimension);
                }
            }
        });
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
    }

    public static void fadeIn(View v, int duration) {
        Transitions.fadeIn(v, duration, null);
    }

    public static void fadeIn(View v, int duration, final EndAction action) {
        Color fadeColor = v.isBlank();
        if (fadeColor == null) {
            return;
        }
        final Camera c = v.getCameraNumber(v.getLayerCount() - 1);
        double[] wnes = v.getVisibleRegion(c);
        final VRectangle fadeRect = new VRectangle((wnes[0] + wnes[2]) / 2.0, (wnes[1] + wnes[3]) / 2.0, 0, wnes[2] - wnes[0], wnes[1] - wnes[3], fadeColor, fadeColor, 1.0f);
        fadeRect.setDrawBorder(false);
        c.getOwningSpace().addGlyph(fadeRect);
        v.setBlank(null);
        VirtualSpaceManager.INSTANCE.repaint();
        Animation trans = VirtualSpaceManager.INSTANCE.getAnimationManager().getAnimationFactory().createTranslucencyAnim(duration, fadeRect, 0.0f, false, IdentityInterpolator.getInstance(), new EndAction(){

            public void execute(Object subject, Animation.Dimension dimension) {
                c.getOwningSpace().removeGlyph(fadeRect);
                if (null != action) {
                    action.execute(subject, dimension);
                }
            }
        });
        VirtualSpaceManager.INSTANCE.getAnimationManager().startAnimation(trans, false);
    }
}

