/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation.examples;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.EndAction;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.Vector;

public class TestStopCancel {
    VirtualSpaceManager vsm = VirtualSpaceManager.INSTANCE;
    VirtualSpace vs;
    ViewListener eh;
    View testView;
    Camera cam;

    TestStopCancel() {
        VirtualSpaceManager.setDebug(true);
    }

    public void startAnim(String vt) {
        this.eh = new MyEventHandler(this);
        this.vs = this.vsm.addVirtualSpace("src");
        this.cam = this.vs.addCamera();
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(this.cam);
        this.cam.setZoomFloor(-90.0);
        this.testView = this.vsm.addFrameView(cameras, "Test", vt, 800, 600, true);
        this.testView.setBackgroundColor(Color.LIGHT_GRAY);
        this.testView.setListener(this.eh);
        this.cam.setAltitude(50.0);
        AnimationManager am = this.vsm.getAnimationManager();
        VCircle circle = new VCircle(0.0, 200.0, 0, 30.0, Color.BLUE);
        this.vs.addGlyph(circle);
        VCircle circle2 = new VCircle(60.0, 200.0, 0, 30.0, Color.BLUE);
        this.vs.addGlyph(circle2);
        VCircle circle3 = new VCircle(90.0, 200.0, 0, 30.0, Color.BLUE);
        this.vs.addGlyph(circle3);
        VCircle circle4 = new VCircle(120.0, 200.0, 0, 30.0, Color.BLUE);
        this.vs.addGlyph(circle4);
        class ColorEndAction
        implements EndAction {
            ColorEndAction() {
            }

            public void execute(Object subject, Animation.Dimension dimension) {
                ((Glyph)subject).setColor(Color.GREEN);
            }
        }
        Animation anim = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        Animation anim2 = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle2, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        Animation anim3 = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle3, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        Animation anim4 = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle4, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        Animation anim5 = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle3, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        Animation anim6 = this.vsm.getAnimationManager().getAnimationFactory().createGlyphTranslation(5000, circle4, new Point2D.Double(0.0, -200.0), true, SlowInSlowOutInterpolator.getInstance(), new ColorEndAction());
        am.startAnimation(anim, false);
        am.startAnimation(anim2, false);
        am.startAnimation(anim3, false);
        am.startAnimation(anim4, false);
        am.startAnimation(anim5, false);
        am.startAnimation(anim6, false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        am.stopAnimation(anim);
        am.cancelAnimation(anim2);
        am.stopAnimation(anim5);
        am.cancelAnimation(anim6);
    }

    public static void main(String[] args) {
        System.out.println("-----------------");
        System.out.println("General information");
        System.out.println("JVM version: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        System.out.println("OS type: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + " " + System.getProperty("sun.cpu.isalist"));
        System.out.println("-----------------");
        System.out.println("Directory information");
        System.out.println("Java Classpath: " + System.getProperty("java.class.path"));
        System.out.println("Java directory: " + System.getProperty("java.home"));
        System.out.println("Launching from: " + System.getProperty("user.dir"));
        System.out.println("-----------------");
        System.out.println("User informations");
        System.out.println("User name: " + System.getProperty("user.name"));
        System.out.println("User home directory: " + System.getProperty("user.home"));
        System.out.println("-----------------");
        new TestStopCancel().startAnim(args.length > 0 ? args[0] : "std");
    }

    class MyEventHandler
    implements ViewListener {
        TestStopCancel application;
        int lastJPX;
        int lastJPY;

        MyEventHandler(TestStopCancel appli) {
            this.application = appli;
        }

        public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        }

        public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            v.setDrawDrag(true);
            this.application.vsm.getActiveView().mouse.setSensitivity(false);
        }

        public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
            this.application.cam.setXspeed(0.0);
            this.application.cam.setYspeed(0.0);
            this.application.cam.setZspeed(0.0);
            v.setDrawDrag(false);
            this.application.vsm.getActiveView().mouse.setSensitivity(true);
        }

        public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        }

        public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        }

        public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
            if (buttonNumber == 3 || (mod == 4 || mod == 5) && buttonNumber == 1) {
                Camera c = this.application.vsm.getActiveCamera();
                double a = (c.focal + Math.abs(c.altitude)) / c.focal;
                if (mod == 5) {
                    this.application.cam.setXspeed(0.0);
                    this.application.cam.setYspeed(0.0);
                    this.application.cam.setZspeed(c.altitude > 0.0 ? (double)(this.lastJPY - jpy) * (a / 50.0) : (double)(this.lastJPY - jpy) / (a * 50.0));
                } else {
                    this.application.cam.setXspeed(c.altitude > 0.0 ? (double)(jpx - this.lastJPX) * (a / 50.0) : (double)(jpx - this.lastJPX) / (a * 50.0));
                    this.application.cam.setYspeed(c.altitude > 0.0 ? (double)(this.lastJPY - jpy) * (a / 50.0) : (double)(this.lastJPY - jpy) / (a * 50.0));
                    this.application.cam.setZspeed(0.0);
                }
            }
        }

        public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
            Camera c = this.application.vsm.getActiveCamera();
            double a = (c.focal + Math.abs(c.altitude)) / c.focal;
            if (wheelDirection == 1) {
                c.altitudeOffset(-a * 5.0);
                this.application.vsm.repaint();
            } else {
                c.altitudeOffset(a * 5.0);
                this.application.vsm.repaint();
            }
        }

        public void enterGlyph(Glyph g) {
            g.highlight(true, null);
        }

        public void exitGlyph(Glyph g) {
            g.highlight(false, null);
        }

        public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        }

        public void viewActivated(View v) {
        }

        public void viewDeactivated(View v) {
        }

        public void viewIconified(View v) {
        }

        public void viewDeiconified(View v) {
        }

        public void viewClosing(View v) {
            System.exit(0);
        }
    }
}

