/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.SlowInSlowOutInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.VImage;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.Plugin;

public class ToolPalette {
    GraphicsManager grMngr;
    static final String PALETTE_SPACE_NAME = "tps";
    VirtualSpace paletteSpace;
    Camera paletteCamera;
    public static final String PLUGIN_MODE_PREFIX = "plugin";
    static final String TOOLPALETTE_BUTTON = "tpb";
    public static final String STD_NAV_MODE = "st";
    public static final String FL_NAV_MODE = "fl";
    public static final String DM_NAV_MODE = "dm";
    public static final String PL_NAV_MODE = "pl";
    public static final String HIGHLIGHT_MODE = "hi";
    public static final String BRING_AND_GO_MODE = "bg";
    public static final String LINK_SLIDING_MODE = "ls";
    public static final String EDIT_MODE = "ed";
    static final String[] BUILTIN_MODES = new String[]{"st", "fl", "dm", "pl", "hi", "bg", "ls", "ed"};
    static final HashMap<String, String> BUILTIN_MODE_ICON_PATHS = new HashMap(8);
    VImage[] buttons;
    VImage[] selectedButtons;
    static final int VERTICAL_STEP_BETWEEN_ICONS = 30;
    VImage currentModeIcon = null;
    String currentMode = null;
    boolean visible = false;
    boolean paintPalette = true;
    boolean enabled = true;
    public static final int ANIM_TIME = 200;
    public static final int TRIGGER_ZONE_WIDTH = 48;
    public static int TRIGGER_ZONE_HEIGHT;
    short firstPluginModeIndex = (short)-1;
    static final BasicStroke SB_STROKE;
    static final BasicStroke DB_STROKE;
    static String defaultPluginModeClassName;
    HashMap<Short, Plugin> pluginsWithMode;

    ToolPalette(GraphicsManager gm) {
        this.grMngr = gm;
        this.loadBuiltinModes();
        this.loadPluginModes();
        TRIGGER_ZONE_HEIGHT = this.buttons.length * 30 + 24;
        this.selectDefaultMode();
    }

    void loadBuiltinModes() {
        int i;
        this.paletteSpace = this.grMngr.vsm.addVirtualSpace(PALETTE_SPACE_NAME);
        this.paletteCamera = this.paletteSpace.addCamera();
        this.paletteCamera.setAltitude(0.0);
        Plugin[] plugins = this.grMngr.cfgMngr.plugins;
        HashMap modesToDisable = new HashMap(2);
        if (plugins != null) {
            for (i = 0; i < plugins.length; i = (int)((short)(i + 1))) {
                String[] mtd = plugins[i].getDisabledModes();
                if (mtd == null || mtd.length <= 0) continue;
                for (String bimode : mtd) {
                    modesToDisable.put(bimode, null);
                }
            }
        }
        this.buttons = new VImage[BUILTIN_MODES.length - modesToDisable.size()];
        short j = 0;
        for (i = 0; i < BUILTIN_MODES.length; i = (int)((short)(i + 1))) {
            if (modesToDisable.containsKey(BUILTIN_MODES[i])) continue;
            this.buttons[j] = new VImage(0.0, -j * 30, 0, new ImageIcon(this.getClass().getResource(BUILTIN_MODE_ICON_PATHS.get(BUILTIN_MODES[i]))).getImage());
            this.paletteSpace.addGlyph(this.buttons[j]);
            this.buttons[j].setOwner(BUILTIN_MODES[i]);
            this.buttons[j].setType(TOOLPALETTE_BUTTON);
            j = (short)(j + 1);
        }
        this.firstPluginModeIndex = j;
    }

    void selectDefaultMode() {
        if (defaultPluginModeClassName != null && this.pluginsWithMode != null && this.pluginsWithMode.size() > 0) {
            for (Short index : this.pluginsWithMode.keySet()) {
                Plugin p = this.pluginsWithMode.get(index);
                if (!p.getClass().getName().equals(defaultPluginModeClassName)) continue;
                this.selectMode(this.buttons[index]);
                return;
            }
        }
        this.selectMode(this.buttons[0]);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        this.paletteCamera.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStdNavMode() {
        return this.currentMode.equals(STD_NAV_MODE);
    }

    public boolean isFadingLensNavMode() {
        return this.currentMode.equals(FL_NAV_MODE);
    }

    public boolean isDragMagNavMode() {
        return this.currentMode.equals(DM_NAV_MODE);
    }

    public boolean isProbingLensNavMode() {
        return this.currentMode.equals(PL_NAV_MODE);
    }

    public boolean isHighlightMode() {
        return this.currentMode.equals(HIGHLIGHT_MODE);
    }

    public boolean isBringAndGoMode() {
        return this.currentMode.equals(BRING_AND_GO_MODE);
    }

    public boolean isLinkSlidingMode() {
        return this.currentMode.equals(LINK_SLIDING_MODE);
    }

    public boolean isEditMode() {
        return this.currentMode.equals(EDIT_MODE);
    }

    public String getMode() {
        return this.currentMode;
    }

    public void selectMode(VImage icon) {
        boolean newModeSelected = false;
        String previousMode = this.currentMode;
        if (icon != this.currentModeIcon) {
            if (this.currentModeIcon != null) {
                this.currentModeIcon.setStroke(DB_STROKE);
            }
            this.currentModeIcon = icon;
            this.currentModeIcon.setStroke(SB_STROKE);
            this.currentMode = (String)icon.getOwner();
            newModeSelected = true;
        }
        if (newModeSelected && previousMode != null) {
            if (previousMode.equals(DM_NAV_MODE)) {
                this.grMngr.killDM();
            } else if (previousMode.equals(BRING_AND_GO_MODE)) {
                this.grMngr.exitBringAndGoMode();
            } else if (previousMode.equals(STD_NAV_MODE)) {
                this.grMngr.activateDynaSpot(false, false);
            } else if (previousMode.equals(EDIT_MODE)) {
                this.grMngr.geom.clearSplineEditingGlyphs();
            }
            if (this.currentMode.equals(BRING_AND_GO_MODE)) {
                this.grMngr.enterBringAndGoMode();
            } else if (this.currentMode.equals(STD_NAV_MODE) && ConfigManager.DYNASPOT) {
                try {
                    this.grMngr.activateDynaSpot(true, false);
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
            }
            if (previousMode.startsWith(PLUGIN_MODE_PREFIX)) {
                this.getPlugin(Short.parseShort(previousMode.substring(PLUGIN_MODE_PREFIX.length()))).exitMode();
            }
            if (this.currentMode.startsWith(PLUGIN_MODE_PREFIX)) {
                this.getPlugin(Short.parseShort(this.currentMode.substring(PLUGIN_MODE_PREFIX.length()))).enterMode();
            }
        }
    }

    public void displayPalette(boolean b) {
        if (this.paintPalette == b) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setVisible(b);
        }
        this.paintPalette = b;
    }

    public void updateHiddenPosition() {
        double[] wnes = this.grMngr.mainView.getVisibleRegion(this.paletteCamera);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].moveTo(wnes[0] - this.buttons[i].getWidth() / 2.0 + 1.0, wnes[1] - (double)((i + 1) * 30));
        }
        this.displayPalette(true);
    }

    public void show() {
        if (!this.visible) {
            this.visible = true;
            Animation a = this.grMngr.vsm.getAnimationManager().getAnimationFactory().createCameraTranslation(200, this.paletteCamera, new Point2D.Double(-this.buttons[0].getWidth() - 2.0, 0.0), true, SlowInSlowOutInterpolator.getInstance(), null);
            this.grMngr.vsm.getAnimationManager().startAnimation(a, false);
            this.grMngr.mainView.setCursorIcon(12);
            this.grMngr.mainView.setActiveLayer(2);
        }
    }

    public void hide() {
        if (this.visible) {
            this.visible = false;
            Animation a = this.grMngr.vsm.getAnimationManager().getAnimationFactory().createCameraTranslation(200, this.paletteCamera, new Point2D.Double(this.buttons[0].getWidth() + 2.0, 0.0), true, SlowInSlowOutInterpolator.getInstance(), null);
            this.grMngr.vsm.getAnimationManager().startAnimation(a, false);
            this.grMngr.mainView.setCursorIcon(-1);
            this.grMngr.mainView.setActiveLayer(0);
        }
    }

    public boolean insidePaletteTriggerZone(int jpx, int jpy) {
        return this.paintPalette && jpx < 48 && jpy < TRIGGER_ZONE_HEIGHT;
    }

    public boolean isShowing() {
        return this.visible;
    }

    public Camera getPaletteCamera() {
        return this.paletteCamera;
    }

    static void setDefaultPluginMode(String pluginClassName) {
        defaultPluginModeClassName = pluginClassName;
    }

    void loadPluginModes() {
        Plugin[] plugins = this.grMngr.cfgMngr.plugins;
        if (plugins == null) {
            return;
        }
        Vector<Plugin> pwm = new Vector<Plugin>(plugins.length);
        for (int i = 0; i < plugins.length; ++i) {
            if (!plugins[i].hasMode()) continue;
            pwm.add(plugins[i]);
        }
        if (pwm.isEmpty()) {
            return;
        }
        this.pluginsWithMode = new HashMap(pwm.size());
        VImage[] nbuttons = new VImage[this.buttons.length + pwm.size()];
        System.arraycopy(this.buttons, 0, nbuttons, 0, this.buttons.length);
        this.buttons = nbuttons;
        for (int i = this.firstPluginModeIndex; i < this.firstPluginModeIndex + pwm.size(); ++i) {
            Plugin p = (Plugin)pwm.elementAt(i - this.firstPluginModeIndex);
            this.pluginsWithMode.put(new Short((short)i), p);
            this.buttons[i] = new VImage(0.0, -i * 30, 0, p.getModeIcon());
            this.buttons[i].setOwner(PLUGIN_MODE_PREFIX + String.valueOf(i));
            this.buttons[i].setType(TOOLPALETTE_BUTTON);
            this.paletteSpace.addGlyph(this.buttons[i]);
        }
    }

    Plugin getPlugin(short index) {
        return this.pluginsWithMode.get(new Short(index));
    }

    static {
        BUILTIN_MODE_ICON_PATHS.put(STD_NAV_MODE, "/images/stdnav24b.png");
        BUILTIN_MODE_ICON_PATHS.put(FL_NAV_MODE, "/images/flnav24b.png");
        BUILTIN_MODE_ICON_PATHS.put(DM_NAV_MODE, "/images/dmnav24b.png");
        BUILTIN_MODE_ICON_PATHS.put(PL_NAV_MODE, "/images/plnav24b.png");
        BUILTIN_MODE_ICON_PATHS.put(HIGHLIGHT_MODE, "/images/hl24b.png");
        BUILTIN_MODE_ICON_PATHS.put(BRING_AND_GO_MODE, "/images/fl24b.png");
        BUILTIN_MODE_ICON_PATHS.put(LINK_SLIDING_MODE, "/images/ls24b.png");
        BUILTIN_MODE_ICON_PATHS.put(EDIT_MODE, "/images/edit24b.png");
        TRIGGER_ZONE_HEIGHT = BUILTIN_MODES.length * 30 + 24;
        SB_STROKE = new BasicStroke(2.0f);
        DB_STROKE = new BasicStroke(1.0f);
        defaultPluginModeClassName = null;
    }
}

