/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration.handlers;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.efm.execution.launchconfiguration.handlers.Util;
import org.eclipse.efm.execution.launchconfiguration.job.RunSewFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunSewToolsHandler
extends AbstractHandler {
    private IFile fLastSelectionFile = null;

    private Object executeWorkflow(ExecutionEvent event, IWorkbenchWindow window, IFile sewFile) {
        this.fLastSelectionFile = sewFile;
        RunSewFactory.run(window, sewFile);
        return null;
    }

    private Object executeGraphiz(ExecutionEvent event, IWorkbenchWindow window, IFile gvFile) {
        this.fLastSelectionFile = gvFile;
        if (SymbexPreferenceUtil.hasExternalDotGraphViewerPath()) {
            try {
                String[] cmdLine = new String[]{SymbexPreferenceUtil.strExternalDotGraphViewerPath(), gvFile.getLocation().toOSString()};
                File workingDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                Process viewerProcess = Runtime.getRuntime().exec(cmdLine, null, workingDir);
                if (viewerProcess == null) {
                    System.out.println(event.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MessageDialog.openWarning((Shell)window.getShell(), (String)"Preference Warning", (String)"Set GraphViz viewer tools preference property");
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput editorInput;
        IFile selectedFile;
        Object selObj;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (selObj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            selectedFile = (IFile)selObj;
            if (Util.isWorkflowFile(selectedFile)) {
                return this.executeWorkflow(event, window, selectedFile);
            }
            if (Util.isGraphizFile(selectedFile)) {
                return this.executeGraphiz(event, window, selectedFile);
            }
        }
        if ((editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof IFileEditorInput) {
            selectedFile = ((IFileEditorInput)editorInput).getFile();
            if (Util.isWorkflowFile(selectedFile)) {
                return this.executeWorkflow(event, window, selectedFile);
            }
            if (Util.isGraphizFile(selectedFile)) {
                return this.executeGraphiz(event, window, selectedFile);
            }
        }
        if (this.fLastSelectionFile != null && this.fLastSelectionFile.exists()) {
            if (Util.isWorkflowFile(this.fLastSelectionFile)) {
                return this.executeWorkflow(event, window, this.fLastSelectionFile);
            }
            if (Util.isGraphizFile(this.fLastSelectionFile)) {
                return this.executeGraphiz(event, window, this.fLastSelectionFile);
            }
        }
        return null;
    }
}

