/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.jaxrs;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import org.eclipse.krazo.jaxrs.JaxRsContext;

@RequestScoped
public class JaxRsContextProducer {
    private Configuration configuration;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Application application;
    private UriInfo uriInfo;
    private ResourceInfo resourceInfo;

    @Produces
    @JaxRsContext
    @RequestScoped
    public Configuration produceConfiguration() {
        return Objects.requireNonNull(this.configuration, "Cannot produce Configuration");
    }

    @Produces
    @JaxRsContext
    @RequestScoped
    public HttpServletRequest produceHttpServletRequest() {
        return Objects.requireNonNull(this.request, "Cannot produce HttpServletRequest");
    }

    @Produces
    @JaxRsContext
    @RequestScoped
    public HttpServletResponse produceHttpServletResponse() {
        return Objects.requireNonNull(this.response, "Cannot produce HttpServletResponse");
    }

    @Produces
    @JaxRsContext
    @RequestScoped
    public Application produceApplication() {
        return Objects.requireNonNull(this.application, "Cannot produce Application");
    }

    @Produces
    @JaxRsContext
    @RequestScoped
    public UriInfo produceUriInfo() {
        return Objects.requireNonNull(this.uriInfo, "Cannot produce UriInfo");
    }

    @Produces
    @JaxRsContext
    @RequestScoped
    public ResourceInfo produceResourceInfo() {
        return Objects.requireNonNull(this.resourceInfo, "Cannot produce ResourceInfo");
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "Configuration must not be null");
    }

    protected void setRequest(HttpServletRequest request) {
        this.request = Objects.requireNonNull(request, "Request must not be null");
    }

    protected void setResponse(HttpServletResponse response) {
        this.response = Objects.requireNonNull(response, "Response must not be null");
    }

    protected void setApplication(Application application) {
        this.application = Objects.requireNonNull(application, "Application must not be null");
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = Objects.requireNonNull(uriInfo, "UriInfo must not be null");
    }

    protected void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = Objects.requireNonNull(resourceInfo, "ResourceInfo must not be null");
    }
}

