/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class UnregistrationListener
implements NotificationListener {
    final MBeanServerConnection mMBeanServer;
    final ObjectName mObjectName;
    final CountDownLatch mLatch;

    public UnregistrationListener(MBeanServerConnection conn, ObjectName objectName) {
        this.mMBeanServer = conn;
        this.mObjectName = objectName;
        this.mLatch = new CountDownLatch(1);
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        if (notifIn instanceof MBeanServerNotification && (notif = (MBeanServerNotification)notifIn).getType().equals("JMX.mbean.unregistered") && this.mObjectName.equals(notif.getMBeanName())) {
            this.mLatch.countDown();
        }
    }

    private static void cdebug(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForUnregister(long timeoutMillis) {
        boolean unregisteredOK;
        block9: {
            unregisteredOK = false;
            try {
                if (this.mMBeanServer.isRegistered(this.mObjectName)) {
                    try {
                        boolean unlatched;
                        JMXUtil.listenToMBeanServerDelegate(this.mMBeanServer, this, null, this.mObjectName);
                        unregisteredOK = this.mMBeanServer.isRegistered(this.mObjectName) ? (unlatched = this.mLatch.await(timeoutMillis, TimeUnit.MILLISECONDS)) : true;
                        break block9;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InstanceNotFoundException e) {
                        break block9;
                    }
                    finally {
                        this.mMBeanServer.removeNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this);
                    }
                }
                unregisteredOK = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return unregisteredOK;
    }
}

