/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.util.Locale;

public class BeanValidation {
    public static Validator getBeanValidator(FacesContext context) {
        ValidatorFactory validatorFactory = BeanValidation.getValidatorFactory(context);
        ValidatorContext validatorContext = validatorFactory.usingContext();
        JsfAwareMessageInterpolator jsfMessageInterpolator = new JsfAwareMessageInterpolator(context, validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
        return validatorContext.getValidator();
    }

    public static ValidatorFactory getValidatorFactory(FacesContext context) {
        ValidatorFactory validatorFactory = null;
        Object cachedObject = context.getExternalContext().getApplicationMap().get("jakarta.faces.validator.beanValidator.ValidatorFactory");
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", e);
            }
            context.getExternalContext().getApplicationMap().put("jakarta.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
        }
        return validatorFactory;
    }

    private static class JsfAwareMessageInterpolator
    implements MessageInterpolator {
        private final FacesContext context;
        private final MessageInterpolator delegate;

        public JsfAwareMessageInterpolator(FacesContext context, MessageInterpolator delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            Locale locale = this.context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return this.delegate.interpolate(message, context, locale);
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, locale);
        }
    }
}

